/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.postnet;

import ai.org.krysalis.barcode4j.BarGroup;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;

public class POSTNETLogicImpl {
    private static final byte[][] CHARSET = new byte[][]{{2, 2, 1, 1, 1}, {1, 1, 1, 2, 2}, {1, 1, 2, 1, 2}, {1, 1, 2, 2, 1}, {1, 2, 1, 1, 2}, {1, 2, 1, 2, 1}, {1, 2, 2, 1, 1}, {2, 1, 1, 1, 2}, {2, 1, 1, 2, 1}, {2, 1, 2, 1, 1}};
    private static final char DASH = '-';
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayChecksum = false;

    public POSTNETLogicImpl(ChecksumMode checksumMode, boolean bl) {
        this.checksumMode = checksumMode;
        this.displayChecksum = bl;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public static char calcChecksum(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (POSTNETLogicImpl.isIgnoredChar(string.charAt(i)) || (n += Character.digit(string.charAt(i), 10)) <= 9) continue;
            n -= 10;
        }
        return Character.forDigit((10 - n) % 10, 10);
    }

    public static boolean validateChecksum(String string) {
        char c;
        char c2 = string.charAt(string.length() - 1);
        return c2 == (c = POSTNETLogicImpl.calcChecksum(string.substring(0, string.length() - 1)));
    }

    private static boolean isValidChar(char c) {
        return Character.isDigit(c) || POSTNETLogicImpl.isIgnoredChar(c);
    }

    public static boolean isIgnoredChar(char c) {
        return c == '-';
    }

    public static String removeIgnoredCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!POSTNETLogicImpl.isValidChar(c)) {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            if (POSTNETLogicImpl.isIgnoredChar(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int heightAt(char c, int n) {
        int n2 = Character.digit(c, 10);
        if (n2 >= 0) {
            byte by = CHARSET[n2][n];
            return by;
        }
        throw new IllegalArgumentException("Invalid character: " + c);
    }

    protected void encodeChar(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, char c) {
        if (POSTNETLogicImpl.isIgnoredChar(c)) {
            return;
        }
        classicBarcodeLogicHandler.startBarGroup(BarGroup.MSG_CHARACTER, new Character(c).toString());
        for (int n = 0; n < 5; n = (int)((byte)(n + 1))) {
            int n2 = this.heightAt(c, n);
            classicBarcodeLogicHandler.addBar(true, n2);
            this.addIntercharacterGap(classicBarcodeLogicHandler);
        }
        classicBarcodeLogicHandler.endBarGroup();
    }

    private void addIntercharacterGap(ClassicBarcodeLogicHandler classicBarcodeLogicHandler) {
        classicBarcodeLogicHandler.addBar(false, -1);
    }

    private String handleChecksum(StringBuffer stringBuffer) {
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            if (this.displayChecksum) {
                stringBuffer.append(POSTNETLogicImpl.calcChecksum(stringBuffer.toString()));
                return stringBuffer.toString();
            }
            String string = stringBuffer.toString();
            stringBuffer.append(POSTNETLogicImpl.calcChecksum(string));
            return string;
        }
        if (this.getChecksumMode() == ChecksumMode.CP_CHECK) {
            if (!POSTNETLogicImpl.validateChecksum(stringBuffer.toString())) {
                throw new IllegalArgumentException("Message '" + stringBuffer.toString() + "' has a bad checksum. Expected: " + POSTNETLogicImpl.calcChecksum(stringBuffer.substring(0, stringBuffer.length() - 1)));
            }
            if (this.displayChecksum) {
                return stringBuffer.toString();
            }
            return stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        if (this.getChecksumMode() == ChecksumMode.CP_IGNORE) {
            return stringBuffer.toString();
        }
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            return stringBuffer.toString();
        }
        throw new UnsupportedOperationException("Unknown checksum mode: " + this.getChecksumMode());
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = this.handleChecksum(stringBuffer);
        classicBarcodeLogicHandler.startBarcode(stringBuffer.toString(), string2);
        classicBarcodeLogicHandler.addBar(true, 2);
        this.addIntercharacterGap(classicBarcodeLogicHandler);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (!POSTNETLogicImpl.isValidChar(c)) {
                throw new IllegalArgumentException("Invalid character: " + c);
            }
            this.encodeChar(classicBarcodeLogicHandler, c);
        }
        classicBarcodeLogicHandler.addBar(true, 2);
        classicBarcodeLogicHandler.endBarcode();
    }
}

