/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.pdf417;

import ai.org.krysalis.barcode4j.impl.pdf417.PDF417Constants;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public class PDF417HighLevelEncoder
implements PDF417Constants {
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;

    public static byte[] getBytesForMessage(String string) {
        try {
            return string.getBytes("cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("Incompatible JVM! The 'cp437' charset is not available!");
        }
    }

    public static String encodeHighLevel(String string) {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string, n2);
            if (n6 >= 13) {
                stringBuffer.append('\u0386');
                n3 = 2;
                n4 = 0;
                PDF417HighLevelEncoder.encodeNumeric(string, n2, n6, stringBuffer);
                n2 += n6;
                continue;
            }
            int n7 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string, n2);
            if (n7 >= 5 || n6 == n) {
                if (n3 != 0) {
                    stringBuffer.append('\u0384');
                    n3 = 0;
                    n4 = 0;
                }
                n4 = PDF417HighLevelEncoder.encodeText(string, n2, n7, stringBuffer, n4);
                n2 += n7;
                continue;
            }
            if (byArray == null) {
                byArray = PDF417HighLevelEncoder.getBytesForMessage(string);
            }
            if ((n5 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string, byArray, n2)) == 0) {
                n5 = 1;
            }
            if (n5 == 1 && n3 == 0) {
                PDF417HighLevelEncoder.encodeBinary(string, byArray, n2, n5, n3, stringBuffer);
            } else {
                PDF417HighLevelEncoder.encodeBinary(string, byArray, n2, n5, n3, stringBuffer);
                n3 = 1;
                n4 = 0;
            }
            n2 += n5;
        }
        return stringBuffer.toString();
    }

    public static int encodeText(String string, int n, int n2, StringBuffer stringBuffer, int n3) {
        int n4;
        char c;
        StringBuffer stringBuffer2 = new StringBuffer(n2);
        int n5 = n3;
        int n6 = 0;
        block5: while (true) {
            c = string.charAt(n + n6);
            switch (n5) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        if (c != ' ') {
                            stringBuffer2.append((char)(c - 65));
                            break;
                        }
                        stringBuffer2.append('\u001a');
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        n5 = 1;
                        stringBuffer2.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        n5 = 2;
                        stringBuffer2.append('\u001c');
                        continue block5;
                    }
                    stringBuffer2.append('\u001d');
                    stringBuffer2.append((char)PUNCTUATION[c]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        if (c != ' ') {
                            stringBuffer2.append((char)(c - 97));
                            break;
                        }
                        stringBuffer2.append('\u001a');
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        stringBuffer2.append('\u001b');
                        stringBuffer2.append((char)(c - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        n5 = 2;
                        stringBuffer2.append('\u001c');
                        continue block5;
                    }
                    stringBuffer2.append('\u001d');
                    stringBuffer2.append((char)PUNCTUATION[c]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.isMixed(c)) {
                        stringBuffer2.append((char)MIXED[c]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c)) {
                        n5 = 0;
                        stringBuffer2.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c)) {
                        n5 = 1;
                        stringBuffer2.append('\u001b');
                        continue block5;
                    }
                    if (n + n6 + 1 < n2 && PDF417HighLevelEncoder.isPunctuation((char)(n4 = (int)string.charAt(n + n6 + 1)))) {
                        n5 = 3;
                        stringBuffer2.append('\u0019');
                        continue block5;
                    }
                    stringBuffer2.append('\u001d');
                    stringBuffer2.append((char)PUNCTUATION[c]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(c)) {
                        stringBuffer2.append((char)PUNCTUATION[c]);
                        break;
                    }
                    n5 = 0;
                    stringBuffer2.append('\u001d');
                    continue block5;
                }
            }
            if (++n6 >= n2) break;
        }
        c = '\u0000';
        n4 = stringBuffer2.length();
        for (int i = 0; i < n4; ++i) {
            boolean bl;
            boolean bl2 = bl = i % 2 != 0;
            if (bl) {
                c = (char)(c * 30 + stringBuffer2.charAt(i));
                stringBuffer.append(c);
                continue;
            }
            c = stringBuffer2.charAt(i);
        }
        if (n4 % 2 != 0) {
            stringBuffer.append((char)(c * 30 + 29));
        }
        return n5;
    }

    public static void encodeBinary(String string, byte[] byArray, int n, int n2, int n3, StringBuffer stringBuffer) {
        if (n2 == 1 && n3 == 0) {
            stringBuffer.append('\u0391');
        } else {
            boolean bl;
            boolean bl2 = bl = n2 % 6 == 0;
            if (bl) {
                stringBuffer.append('\u039c');
            } else {
                stringBuffer.append('\u0385');
            }
        }
        char[] cArray = new char[5];
        int n4 = n;
        while (n + n2 - n4 >= 6) {
            int n5;
            long l = 0L;
            for (n5 = 0; n5 < 6; ++n5) {
                l <<= 8;
                l += (long)(byArray[n4 + n5] & 0xFF);
            }
            for (n5 = 0; n5 < 5; ++n5) {
                cArray[n5] = (char)(l % 900L);
                l /= 900L;
            }
            for (n5 = cArray.length - 1; n5 >= 0; --n5) {
                stringBuffer.append(cArray[n5]);
            }
            n4 += 6;
        }
        for (int i = n4; i < n + n2; ++i) {
            int n6 = byArray[i] & 0xFF;
            stringBuffer.append((char)n6);
        }
    }

    public static void encodeNumeric(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        StringBuffer stringBuffer2 = new StringBuffer(n2 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i = 0; i < n2 - 1; i += n3) {
            stringBuffer2.setLength(0);
            n3 = Math.min(44, n2 - i);
            String string2 = "1" + string.substring(n + i, n + i + n3);
            BigInteger bigInteger3 = new BigInteger(string2);
            do {
                BigInteger bigInteger4 = bigInteger3.mod(bigInteger);
                stringBuffer2.append((char)bigInteger4.intValue());
            } while (!(bigInteger3 = bigInteger3.divide(bigInteger)).equals(bigInteger2));
            for (int j = stringBuffer2.length() - 1; j >= 0; --j) {
                stringBuffer.append(stringBuffer2.charAt(j));
            }
        }
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphaUpper(char c) {
        return c == ' ' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphaLower(char c) {
        return c == ' ' || c >= 'a' && c <= 'z';
    }

    private static boolean isMixed(char c) {
        return MIXED[c] != -1;
    }

    private static boolean isPunctuation(char c) {
        return PUNCTUATION[c] != -1;
    }

    private static boolean isText(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '~';
    }

    public static int determineConsecutiveDigitCount(String string, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        if (n3 < n4) {
            char c = string.charAt(n3);
            while (PDF417HighLevelEncoder.isDigit(c) && n3 < n4) {
                ++n2;
                if (++n3 >= n4) continue;
                c = string.charAt(n3);
            }
        }
        return n2;
    }

    public static int determineConsecutiveTextCount(String string, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            int n4;
            char c = string.charAt(n3);
            for (n4 = 0; n4 < 13 && PDF417HighLevelEncoder.isDigit(c) && n3 < n2; ++n4) {
                if (++n3 >= n2) continue;
                c = string.charAt(n3);
            }
            if (n4 >= 13) {
                return n3 - n - n4;
            }
            if (n4 > 0) continue;
            c = string.charAt(n3);
            if (!PDF417HighLevelEncoder.isText(c)) break;
            ++n3;
        }
        return n3 - n;
    }

    public static int determineConsecutiveBinaryCount(String string, byte[] byArray, int n) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3; ++n2) {
            int n4;
            char c = string.charAt(n2);
            int n5 = 0;
            int n6 = 0;
            while (n5 < 13 && PDF417HighLevelEncoder.isDigit(c) && (n4 = n2 + ++n5) < n3) {
                c = string.charAt(n4);
            }
            if (n5 >= 13) {
                return n2 - n;
            }
            while (n6 < 5 && PDF417HighLevelEncoder.isText(c) && (n4 = n2 + ++n6) < n3) {
                c = string.charAt(n4);
            }
            if (n6 >= 5) {
                return n2 - n;
            }
            c = string.charAt(n2);
            if (byArray[n2] != 63 || c == '?') continue;
            throw new IllegalArgumentException("Non-encodable character detected: " + c + " (Unicode: " + c + ")");
        }
        return n2 - n;
    }

    static {
        byte by;
        int n;
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        Arrays.fill(MIXED, (byte)-1);
        for (n = 0; n < TEXT_MIXED_RAW.length; n = (int)((byte)(n + 1))) {
            by = TEXT_MIXED_RAW[n];
            if (by <= 0) continue;
            PDF417HighLevelEncoder.MIXED[by] = n;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (n = 0; n < TEXT_PUNCTUATION_RAW.length; n = (int)((byte)(n + 1))) {
            by = TEXT_PUNCTUATION_RAW[n];
            if (by <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[by] = n;
        }
    }
}

