/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.pdf417;

import ai.org.krysalis.barcode4j.impl.pdf417.PDF417Constants;

public class PDF417ErrorCorrection
implements PDF417Constants {
    public static int getErrorCorrectionCodewordCount(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
        }
        return 1 << n + 1;
    }

    public static int getRecommendedMinimumErrorCorrectionLevel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (n >= 1 && n <= 40) {
            return 2;
        }
        if (n >= 41 && n <= 160) {
            return 3;
        }
        if (n >= 161 && n <= 320) {
            return 4;
        }
        if (n >= 321 && n <= 863) {
            return 5;
        }
        throw new IllegalArgumentException("No recommendation possible");
    }

    public static String generateErrorCorrection(String string, int n) {
        int n2;
        int n3 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(n);
        char[] cArray = new char[n3];
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            int n7 = (string.charAt(i) + cArray[cArray.length - 1]) % 929;
            for (n2 = n3 - 1; n2 >= 1; --n2) {
                n6 = n7 * EC_COEFFICIENTS[n][n2] % 929;
                n5 = 929 - n6;
                cArray[n2] = (char)((cArray[n2 - 1] + n5) % 929);
            }
            n6 = n7 * EC_COEFFICIENTS[n][0] % 929;
            n5 = 929 - n6;
            cArray[0] = (char)(n5 % 929);
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (cArray[n2] != '\u0000') {
                cArray[n2] = (char)(929 - cArray[n2]);
            }
            stringBuffer.append(cArray[n2]);
        }
        return stringBuffer.toString();
    }
}

