/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.pdf417;

import ai.org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import ai.org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import ai.org.krysalis.barcode4j.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class PDF417
extends ConfigurableBarcodeGenerator
implements Configurable {
    public PDF417() {
        this.bean = new PDF417Bean();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Length length;
        String string = configuration.getChild("module-width").getValue(null);
        if (string != null) {
            length = new Length(string, "mm");
            this.getPDF417Bean().setModuleWidth(length.getValueAsMillimeter());
        }
        super.configure(configuration);
        length = configuration.getChild("min-columns", false);
        if (length != null) {
            this.getPDF417Bean().setMinCols(length.getValueAsInteger());
        }
        if ((length = configuration.getChild("max-columns", false)) != null) {
            this.getPDF417Bean().setMaxCols(length.getValueAsInteger());
        }
        if ((length = configuration.getChild("min-rows", false)) != null) {
            this.getPDF417Bean().setMinRows(length.getValueAsInteger());
        }
        if ((length = configuration.getChild("max-rows", false)) != null) {
            this.getPDF417Bean().setMaxRows(length.getValueAsInteger());
        }
        if ((length = configuration.getChild("columns", false)) != null) {
            this.getPDF417Bean().setColumns(length.getValueAsInteger());
        }
        this.getPDF417Bean().setErrorCorrectionLevel(configuration.getChild("ec-level").getValueAsInteger(0));
        String string2 = configuration.getChild("row-height").getValue(null);
        if (string2 != null) {
            Length length2 = new Length(string2, "mw");
            if (length2.getUnit().equalsIgnoreCase("mw")) {
                this.getPDF417Bean().setRowHeight(length2.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getPDF417Bean().setRowHeight(length2.getValueAsMillimeter());
            }
        } else {
            this.getPDF417Bean().setRowHeight(3.0 * this.getBean().getModuleWidth());
        }
        length = configuration.getChild("width-to-height-ratio", false);
        if (length != null) {
            this.getPDF417Bean().setWidthToHeightRatio(length.getValueAsFloat());
        }
    }

    public PDF417Bean getPDF417Bean() {
        return (PDF417Bean)this.getBean();
    }
}

