/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.fourstate;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.impl.fourstate.AbstractFourStateBean;
import ai.org.krysalis.barcode4j.impl.fourstate.FourStateLogicHandler;
import ai.org.krysalis.barcode4j.impl.fourstate.RoyalMailCBCLogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class RoyalMailCBCBean
extends AbstractFourStateBean {
    protected static final double DEFAULT_MODULE_WIDTH = 0.53;

    public RoyalMailCBCBean() {
        this.msgPos = HumanReadablePlacement.HRP_NONE;
        this.setModuleWidth(0.53);
        this.setTrackHeight(1.25);
        this.setAscenderHeight(1.8f);
        this.setQuietZone(2.0);
        this.setIntercharGapWidth(this.getModuleWidth());
        this.updateHeight();
    }

    public void setMsgPosition(HumanReadablePlacement humanReadablePlacement) {
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        FourStateLogicHandler fourStateLogicHandler = new FourStateLogicHandler(this, new Canvas(canvasProvider));
        RoyalMailCBCLogicImpl royalMailCBCLogicImpl = new RoyalMailCBCLogicImpl(this.getChecksumMode());
        royalMailCBCLogicImpl.generateBarcodeLogic(fourStateLogicHandler, string);
    }

    public BarcodeDimension calcDimensions(String string) {
        String string2 = RoyalMailCBCLogicImpl.removeStartStop(string);
        int n = this.getChecksumMode() == ChecksumMode.CP_ADD || this.getChecksumMode() == ChecksumMode.CP_AUTO ? 1 : 0;
        int n2 = string2.length() + n;
        double d = (double)(n2 * 4 + 2) * this.moduleWidth + (double)(n2 * 4 + 1) * this.getIntercharGapWidth();
        double d2 = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double d3 = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(d, this.getBarHeight(), d + 2.0 * d2, this.getBarHeight() + 2.0 * d3, d2, d3);
    }
}

