/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.datamatrix;

import ai.org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import java.awt.Dimension;

public class DataMatrixSymbolInfo {
    public static final DataMatrixSymbolInfo[] PROD_SYMBOLS = new DataMatrixSymbolInfo[]{new DataMatrixSymbolInfo(false, 3, 5, 8, 8, 1), new DataMatrixSymbolInfo(false, 5, 7, 10, 10, 1), new DataMatrixSymbolInfo(true, 5, 7, 16, 6, 1), new DataMatrixSymbolInfo(false, 8, 10, 12, 12, 1), new DataMatrixSymbolInfo(true, 10, 11, 14, 6, 2), new DataMatrixSymbolInfo(false, 12, 12, 14, 14, 1), new DataMatrixSymbolInfo(true, 16, 14, 24, 10, 1), new DataMatrixSymbolInfo(false, 18, 14, 16, 16, 1), new DataMatrixSymbolInfo(false, 22, 18, 18, 18, 1), new DataMatrixSymbolInfo(true, 22, 18, 16, 10, 2), new DataMatrixSymbolInfo(false, 30, 20, 20, 20, 1), new DataMatrixSymbolInfo(true, 32, 24, 16, 14, 2), new DataMatrixSymbolInfo(false, 36, 24, 22, 22, 1), new DataMatrixSymbolInfo(false, 44, 28, 24, 24, 1), new DataMatrixSymbolInfo(true, 49, 28, 22, 14, 2), new DataMatrixSymbolInfo(false, 62, 36, 14, 14, 4), new DataMatrixSymbolInfo(false, 86, 42, 16, 16, 4), new DataMatrixSymbolInfo(false, 114, 48, 18, 18, 4), new DataMatrixSymbolInfo(false, 144, 56, 20, 20, 4), new DataMatrixSymbolInfo(false, 174, 68, 22, 22, 4), new DataMatrixSymbolInfo(false, 204, 84, 24, 24, 4, 102, 42), new DataMatrixSymbolInfo(false, 280, 112, 14, 14, 16, 140, 56), new DataMatrixSymbolInfo(false, 368, 144, 16, 16, 16, 92, 36), new DataMatrixSymbolInfo(false, 456, 192, 18, 18, 16, 114, 48), new DataMatrixSymbolInfo(false, 576, 224, 20, 20, 16, 144, 56), new DataMatrixSymbolInfo(false, 696, 272, 22, 22, 16, 174, 68), new DataMatrixSymbolInfo(false, 816, 336, 24, 24, 16, 136, 56), new DataMatrixSymbolInfo(false, 1050, 408, 18, 18, 36, 175, 68), new DataMatrixSymbolInfo(false, 1304, 496, 20, 20, 36, 163, 62), new DataMatrixSymbolInfo144()};
    private static DataMatrixSymbolInfo[] symbols = PROD_SYMBOLS;
    public boolean rectangular;
    public int dataCapacity;
    public int errorCodewords;
    public int matrixWidth;
    public int matrixHeight;
    public int dataRegions;
    public int rsBlockData;
    public int rsBlockError;

    public static void overrideSymbolSet(DataMatrixSymbolInfo[] dataMatrixSymbolInfoArray) {
        symbols = dataMatrixSymbolInfoArray;
    }

    public DataMatrixSymbolInfo(boolean bl, int n, int n2, int n3, int n4, int n5) {
        this(bl, n, n2, n3, n4, n5, n, n2);
    }

    public DataMatrixSymbolInfo(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.rectangular = bl;
        this.dataCapacity = n;
        this.errorCodewords = n2;
        this.matrixWidth = n3;
        this.matrixHeight = n4;
        this.dataRegions = n5;
        this.rsBlockData = n6;
        this.rsBlockError = n7;
    }

    public static DataMatrixSymbolInfo lookup(int n) {
        return DataMatrixSymbolInfo.lookup(n, SymbolShapeHint.FORCE_NONE, true);
    }

    public static DataMatrixSymbolInfo lookup(int n, SymbolShapeHint symbolShapeHint) {
        return DataMatrixSymbolInfo.lookup(n, symbolShapeHint, true);
    }

    public static DataMatrixSymbolInfo lookup(int n, boolean bl, boolean bl2) {
        SymbolShapeHint symbolShapeHint = bl ? SymbolShapeHint.FORCE_NONE : SymbolShapeHint.FORCE_SQUARE;
        return DataMatrixSymbolInfo.lookup(n, symbolShapeHint, bl2);
    }

    public static DataMatrixSymbolInfo lookup(int n, SymbolShapeHint symbolShapeHint, boolean bl) {
        return DataMatrixSymbolInfo.lookup(n, symbolShapeHint, null, null, bl);
    }

    public static DataMatrixSymbolInfo lookup(int n, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2, boolean bl) {
        for (DataMatrixSymbolInfo dataMatrixSymbolInfo : symbols) {
            if (symbolShapeHint == SymbolShapeHint.FORCE_SQUARE && dataMatrixSymbolInfo.rectangular || symbolShapeHint == SymbolShapeHint.FORCE_RECTANGLE && !dataMatrixSymbolInfo.rectangular || dimension != null && (dataMatrixSymbolInfo.getSymbolWidth() < dimension.width || dataMatrixSymbolInfo.getSymbolHeight() < dimension.height) || dimension2 != null && (dataMatrixSymbolInfo.getSymbolWidth() > dimension2.width || dataMatrixSymbolInfo.getSymbolHeight() > dimension2.height) || n > dataMatrixSymbolInfo.dataCapacity) continue;
            return dataMatrixSymbolInfo;
        }
        if (bl) {
            throw new IllegalArgumentException("Can't find a symbol arrangement that matches the message. Data codewords: " + n);
        }
        return null;
    }

    public int getHorzDataRegions() {
        switch (this.dataRegions) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 36: {
                return 6;
            }
        }
        throw new IllegalStateException("Cannot handle this number of data regions");
    }

    public int getVertDataRegions() {
        switch (this.dataRegions) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 36: {
                return 6;
            }
        }
        throw new IllegalStateException("Cannot handle this number of data regions");
    }

    public int getSymbolDataWidth() {
        return this.getHorzDataRegions() * this.matrixWidth;
    }

    public int getSymbolDataHeight() {
        return this.getVertDataRegions() * this.matrixHeight;
    }

    public int getSymbolWidth() {
        return this.getSymbolDataWidth() + this.getHorzDataRegions() * 2;
    }

    public int getSymbolHeight() {
        return this.getSymbolDataHeight() + this.getVertDataRegions() * 2;
    }

    public int getCodewordCount() {
        return this.dataCapacity + this.errorCodewords;
    }

    public int getInterleavedBlockCount() {
        return this.dataCapacity / this.rsBlockData;
    }

    public int getDataLengthForInterleavedBlock(int n) {
        return this.rsBlockData;
    }

    public int getErrorLengthForInterleavedBlock(int n) {
        return this.rsBlockError;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.rectangular ? "Rectangular Symbol:" : "Square Symbol:");
        stringBuffer.append(" data region " + this.matrixWidth + "x" + this.matrixHeight);
        stringBuffer.append(", symbol size " + this.getSymbolWidth() + "x" + this.getSymbolHeight());
        stringBuffer.append(", symbol data size " + this.getSymbolDataWidth() + "x" + this.getSymbolDataHeight());
        stringBuffer.append(", codewords " + this.dataCapacity + "+" + this.errorCodewords);
        return stringBuffer.toString();
    }

    private static class DataMatrixSymbolInfo144
    extends DataMatrixSymbolInfo {
        public DataMatrixSymbolInfo144() {
            super(false, 1558, 620, 22, 22, 36);
            this.rsBlockData = -1;
            this.rsBlockError = 62;
        }

        public int getInterleavedBlockCount() {
            return 10;
        }

        public int getDataLengthForInterleavedBlock(int n) {
            return n <= 8 ? 156 : 155;
        }
    }
}

