/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.datamatrix;

import ai.org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixErrorCorrection;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixHighLevelEncoder;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixPlacement;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import ai.org.krysalis.barcode4j.impl.datamatrix.DefaultDataMatrixPlacement;
import ai.org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import java.awt.Dimension;
import java.io.IOException;

public class DataMatrixLogicImpl {
    private static final boolean DEBUG = false;

    public void generateBarcodeLogic(TwoDimBarcodeLogicHandler twoDimBarcodeLogicHandler, String string, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) {
        String string2;
        try {
            string2 = DataMatrixHighLevelEncoder.encodeHighLevel(string, symbolShapeHint, dimension, dimension2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot fetch data: " + iOException.getLocalizedMessage());
        }
        DataMatrixSymbolInfo dataMatrixSymbolInfo = DataMatrixSymbolInfo.lookup(string2.length(), symbolShapeHint, dimension, dimension2, true);
        String string3 = DataMatrixErrorCorrection.encodeECC200(string2, dataMatrixSymbolInfo);
        DefaultDataMatrixPlacement defaultDataMatrixPlacement = new DefaultDataMatrixPlacement(string3, dataMatrixSymbolInfo.getSymbolDataWidth(), dataMatrixSymbolInfo.getSymbolDataHeight());
        defaultDataMatrixPlacement.place();
        twoDimBarcodeLogicHandler.startBarcode(string, string);
        this.encodeLowLevel(twoDimBarcodeLogicHandler, defaultDataMatrixPlacement, dataMatrixSymbolInfo);
        twoDimBarcodeLogicHandler.endBarcode();
    }

    private void encodeLowLevel(TwoDimBarcodeLogicHandler twoDimBarcodeLogicHandler, DataMatrixPlacement dataMatrixPlacement, DataMatrixSymbolInfo dataMatrixSymbolInfo) {
        int n = dataMatrixSymbolInfo.getSymbolDataWidth();
        int n2 = dataMatrixSymbolInfo.getSymbolDataHeight();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i % dataMatrixSymbolInfo.matrixHeight == 0) {
                twoDimBarcodeLogicHandler.startRow();
                for (n3 = 0; n3 < dataMatrixSymbolInfo.getSymbolWidth(); ++n3) {
                    twoDimBarcodeLogicHandler.addBar(n3 % 2 == 0, 1);
                }
                twoDimBarcodeLogicHandler.endRow();
            }
            twoDimBarcodeLogicHandler.startRow();
            for (n3 = 0; n3 < n; ++n3) {
                if (n3 % dataMatrixSymbolInfo.matrixWidth == 0) {
                    twoDimBarcodeLogicHandler.addBar(true, 1);
                }
                twoDimBarcodeLogicHandler.addBar(dataMatrixPlacement.getBit(n3, i), 1);
                if (n3 % dataMatrixSymbolInfo.matrixWidth != dataMatrixSymbolInfo.matrixWidth - 1) continue;
                twoDimBarcodeLogicHandler.addBar(i % 2 == 0, 1);
            }
            twoDimBarcodeLogicHandler.endRow();
            if (i % dataMatrixSymbolInfo.matrixHeight != dataMatrixSymbolInfo.matrixHeight - 1) continue;
            twoDimBarcodeLogicHandler.startRow();
            for (n3 = 0; n3 < dataMatrixSymbolInfo.getSymbolWidth(); ++n3) {
                twoDimBarcodeLogicHandler.addBar(true, 1);
            }
            twoDimBarcodeLogicHandler.endRow();
        }
    }
}

