/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.datamatrix;

import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixConstants;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import ai.org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import ai.org.krysalis.barcode4j.tools.URLUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DataMatrixHighLevelEncoder
implements DataMatrixConstants {
    private static final boolean DEBUG = false;
    private static final int ASCII_ENCODATION = 0;
    private static final int C40_ENCODATION = 1;
    private static final int TEXT_ENCODATION = 2;
    private static final int X12_ENCODATION = 3;
    private static final int EDIFACT_ENCODATION = 4;
    private static final int BASE256_ENCODATION = 5;
    private static final String[] ENCODATION_NAMES = new String[]{"ASCII", "C40", "Text", "ANSI X12", "EDIFACT", "Base 256"};
    private static final String DEFAULT_ASCII_ENCODING = "ISO-8859-1";
    private static final String URL_START = "url(";
    private static final String URL_END = ")";

    public static byte[] getBytesForMessage(String string) {
        try {
            return string.getBytes("cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException("Incompatible JVM! The 'cp437' charset is not available!");
        }
    }

    private static char randomize253State(char c, int n) {
        int n2 = 149 * n % 253 + 1;
        int n3 = c + n2;
        if (n3 <= 254) {
            return (char)n3;
        }
        return (char)(n3 - 254);
    }

    private static char randomize255State(char c, int n) {
        int n2 = 149 * n % 255 + 1;
        int n3 = c + n2;
        if (n3 <= 255) {
            return (char)n3;
        }
        return (char)(n3 - 256);
    }

    public static String encodeHighLevel(String string) throws IOException {
        return DataMatrixHighLevelEncoder.encodeHighLevel(string, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String string, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) throws IOException {
        StringBuffer stringBuffer;
        Encoder[] encoderArray = new Encoder[]{new ASCIIEncoder(), new C40Encoder(), new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        int n = 0;
        EncoderContext encoderContext = DataMatrixHighLevelEncoder.createEncoderContext(string);
        encoderContext.setSymbolShape(symbolShapeHint);
        encoderContext.setSizeConstraints(dimension, dimension2);
        if (string.startsWith("[)>\u001e05\u001d") && string.endsWith("\u001e\u0004")) {
            encoderContext.writeCodeword('\u00ec');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += "[)>\u001e05\u001d".length();
        } else if (string.startsWith("[)>\u001e06\u001d") && string.endsWith("\u001e\u0004")) {
            encoderContext.writeCodeword('\u00ed');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += "[)>\u001e06\u001d".length();
        }
        while (encoderContext.hasMoreCharacters()) {
            encoderArray[n].encode(encoderContext);
            if (encoderContext.newEncoding < 0) continue;
            n = encoderContext.newEncoding;
            encoderContext.resetEncoderSignal();
        }
        int n2 = encoderContext.codewords.length();
        encoderContext.updateSymbolInfo();
        int n3 = ((EncoderContext)encoderContext).symbolInfo.dataCapacity;
        if (n2 < n3 && n != 0 && n != 5) {
            encoderContext.writeCodeword('\u00fe');
        }
        if ((stringBuffer = encoderContext.codewords).length() < n3) {
            stringBuffer.append('\u0081');
        }
        while (stringBuffer.length() < n3) {
            stringBuffer.append(DataMatrixHighLevelEncoder.randomize253State('\u0081', stringBuffer.length() + 1));
        }
        return encoderContext.codewords.toString();
    }

    private static EncoderContext createEncoderContext(String string) throws IOException {
        if (string.startsWith(URL_START) && string.endsWith(URL_END)) {
            String string2 = string.substring(URL_START.length(), string.length() - URL_END.length());
            byte[] byArray = URLUtil.getData(string2, DEFAULT_ASCII_ENCODING);
            return new EncoderContext(byArray);
        }
        return new EncoderContext(string);
    }

    private static char encodeASCIIDigits(char c, char c2) {
        if (DataMatrixHighLevelEncoder.isDigit(c) && DataMatrixHighLevelEncoder.isDigit(c2)) {
            int n = (c - 48) * 10 + (c2 - 48);
            return (char)(n + 130);
        }
        throw new IllegalArgumentException("not digits: " + c + c2);
    }

    private static int lookAheadTest(String string, int n, int n2) {
        float[] fArray;
        if (n >= string.length()) {
            return n2;
        }
        if (n2 == 0) {
            fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            fArray = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            fArray[n2] = 0.0f;
        }
        int n3 = 0;
        while (true) {
            int[] nArray;
            if (n + n3 == string.length()) {
                int n4 = Integer.MAX_VALUE;
                byte[] byArray = new byte[6];
                nArray = new int[6];
                int n5 = DataMatrixHighLevelEncoder.findMinimums(fArray, nArray, n4, byArray);
                int n6 = DataMatrixHighLevelEncoder.getMinimumCount(byArray);
                if (nArray[0] == n5) {
                    return 0;
                }
                if (n6 == 1 && byArray[5] > 0) {
                    return 5;
                }
                if (n6 == 1 && byArray[4] > 0) {
                    return 4;
                }
                if (n6 == 1 && byArray[2] > 0) {
                    return 2;
                }
                if (n6 == 1 && byArray[3] > 0) {
                    return 3;
                }
                return 1;
            }
            char c = string.charAt(n + n3);
            ++n3;
            if (DataMatrixHighLevelEncoder.isDigit(c)) {
                fArray[0] = (float)((double)fArray[0] + 0.5);
            } else if (DataMatrixHighLevelEncoder.isExtendedASCII(c)) {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 2.0f;
            } else {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 1.0f;
            }
            fArray[1] = DataMatrixHighLevelEncoder.isNativeC40(c) ? fArray[1] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? fArray[1] + 2.6666667f : fArray[1] + 1.3333334f);
            fArray[2] = DataMatrixHighLevelEncoder.isNativeText(c) ? fArray[2] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? fArray[2] + 2.6666667f : fArray[2] + 1.3333334f);
            fArray[3] = DataMatrixHighLevelEncoder.isNativeX12(c) ? fArray[3] + 0.6666667f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? fArray[3] + 4.3333335f : fArray[3] + 3.3333333f);
            fArray[4] = DataMatrixHighLevelEncoder.isNativeEDIFACT(c) ? fArray[4] + 0.75f : (DataMatrixHighLevelEncoder.isExtendedASCII(c) ? fArray[4] + 4.25f : fArray[4] + 3.25f);
            fArray[5] = DataMatrixHighLevelEncoder.isSpecialB256(c) ? fArray[5] + 4.0f : fArray[5] + 1.0f;
            if (n3 < 4) continue;
            int n7 = Integer.MAX_VALUE;
            nArray = new int[6];
            byte[] byArray = new byte[6];
            n7 = DataMatrixHighLevelEncoder.findMinimums(fArray, nArray, n7, byArray);
            int n8 = DataMatrixHighLevelEncoder.getMinimumCount(byArray);
            if (nArray[0] + 1 <= nArray[5] && nArray[0] + 1 <= nArray[1] && nArray[0] + 1 <= nArray[2] && nArray[0] + 1 <= nArray[3] && nArray[0] + 1 <= nArray[4]) {
                return 0;
            }
            if (nArray[5] + 1 <= nArray[0] || byArray[1] + byArray[2] + byArray[3] + byArray[4] == 0) {
                return 5;
            }
            if (n8 == 1 && byArray[4] > 0) {
                return 4;
            }
            if (n8 == 1 && byArray[2] > 0) {
                return 2;
            }
            if (n8 == 1 && byArray[3] > 0) {
                return 3;
            }
            if (nArray[1] + 1 >= nArray[0] || nArray[1] + 1 >= nArray[5] || nArray[1] + 1 >= nArray[4] || nArray[1] + 1 >= nArray[2]) continue;
            if (nArray[1] < nArray[3]) {
                return 1;
            }
            if (nArray[1] == nArray[3]) break;
        }
        for (int i = n + n3 + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (DataMatrixHighLevelEncoder.isX12TermSep(c)) {
                return 3;
            }
            if (!DataMatrixHighLevelEncoder.isNativeX12(c)) break;
        }
        return 1;
    }

    private static int findMinimums(float[] fArray, int[] nArray, int n, byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        for (int i = 0; i < 6; ++i) {
            nArray[i] = (int)Math.ceil(fArray[i]);
            int n2 = nArray[i];
            if (n > n2) {
                n = n2;
                Arrays.fill(byArray, (byte)0);
            }
            if (n != n2) continue;
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] + 1);
        }
        return n;
    }

    private static int getMinimumCount(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n += byArray[i];
        }
        return n;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isExtendedASCII(char c) {
        return c >= '\u0080' && c <= '\u00ff';
    }

    private static boolean isASCII7(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    private static boolean isNativeC40(char c) {
        return c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z';
    }

    private static boolean isNativeText(char c) {
        return c == ' ' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z';
    }

    private static boolean isNativeX12(char c) {
        return DataMatrixHighLevelEncoder.isX12TermSep(c) || c == ' ' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z';
    }

    private static boolean isX12TermSep(char c) {
        return c == '\r' || c == '*' || c == '>';
    }

    private static boolean isNativeEDIFACT(char c) {
        return c >= ' ' && c <= '^';
    }

    private static boolean isSpecialB256(char c) {
        return false;
    }

    public static int determineConsecutiveDigitCount(String string, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        if (n3 < n4) {
            char c = string.charAt(n3);
            while (DataMatrixHighLevelEncoder.isDigit(c) && n3 < n4) {
                ++n2;
                if (++n3 >= n4) continue;
                c = string.charAt(n3);
            }
        }
        return n2;
    }

    private static void illegalCharacter(char c) {
        String string = Integer.toHexString(c);
        string = "0000".substring(0, 4 - string.length()) + string;
        throw new IllegalArgumentException("Illegal character: " + c + " (0x" + string + URL_END);
    }

    private static class Base256Encoder
    implements Encoder {
        private Base256Encoder() {
        }

        public int getEncodingMode() {
            return 5;
        }

        public void encode(EncoderContext encoderContext) {
            boolean bl;
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\u0000');
            while (encoderContext.hasMoreCharacters()) {
                n2 = encoderContext.getCurrentChar();
                stringBuffer.append((char)n2);
                encoderContext.pos++;
                n = DataMatrixHighLevelEncoder.lookAheadTest(encoderContext.msg, encoderContext.pos, this.getEncodingMode());
                if (n == this.getEncodingMode()) continue;
                encoderContext.signalEncoderChange(n);
                break;
            }
            n2 = stringBuffer.length() - 1;
            n = 1;
            int n3 = encoderContext.getCodewordCount() + n2 + n;
            encoderContext.updateSymbolInfo(n3);
            boolean bl2 = bl = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - n3 > 0;
            if (encoderContext.hasMoreCharacters() || bl) {
                if (n2 <= 249) {
                    stringBuffer.setCharAt(0, (char)n2);
                } else if (n2 > 249 && n2 <= 1555) {
                    stringBuffer.setCharAt(0, (char)(n2 / 250 + 249));
                    stringBuffer.insert(1, (char)(n2 % 250));
                } else {
                    throw new IllegalStateException("Message length not in valid ranges: " + n2);
                }
            }
            int n4 = stringBuffer.length();
            for (int i = 0; i < n4; ++i) {
                encoderContext.writeCodeword(DataMatrixHighLevelEncoder.randomize255State(stringBuffer.charAt(i), encoderContext.getCodewordCount() + 1));
            }
        }
    }

    private static class EdifactEncoder
    implements Encoder {
        private EdifactEncoder() {
        }

        public int getEncodingMode() {
            return 4;
        }

        public void encode(EncoderContext encoderContext) {
            StringBuffer stringBuffer = new StringBuffer();
            while (encoderContext.hasMoreCharacters()) {
                char c = encoderContext.getCurrentChar();
                this.encodeChar(c, stringBuffer);
                encoderContext.pos++;
                int n = stringBuffer.length();
                if (n < 4) continue;
                encoderContext.writeCodewords(this.encodeToCodewords(stringBuffer, 0));
                stringBuffer.delete(0, 4);
                int n2 = DataMatrixHighLevelEncoder.lookAheadTest(encoderContext.msg, encoderContext.pos, this.getEncodingMode());
                if (n2 == this.getEncodingMode()) continue;
                encoderContext.signalEncoderChange(0);
                break;
            }
            stringBuffer.append('\u001f');
            this.handleEOD(encoderContext, stringBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleEOD(EncoderContext encoderContext, StringBuffer stringBuffer) {
            try {
                boolean bl;
                int n;
                int n2 = stringBuffer.length();
                if (n2 == 0) {
                    return;
                }
                if (n2 == 1) {
                    encoderContext.updateSymbolInfo();
                    n = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - encoderContext.getCodewordCount();
                    int n3 = encoderContext.getRemainingCharacters();
                    if (n3 == 0 && n <= 2) {
                        return;
                    }
                }
                if (n2 > 4) {
                    throw new IllegalStateException("Count must not exceed 4");
                }
                n = n2 - 1;
                String string = this.encodeToCodewords(stringBuffer, 0);
                boolean bl2 = !encoderContext.hasMoreCharacters();
                boolean bl3 = bl = bl2 && n <= 2;
                if (n <= 2) {
                    encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + n);
                    int n4 = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - encoderContext.getCodewordCount();
                    if (n4 >= 3) {
                        bl = false;
                        encoderContext.updateSymbolInfo(encoderContext.getCodewordCount() + string.length());
                        n4 = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - encoderContext.getCodewordCount();
                    }
                }
                if (bl) {
                    encoderContext.resetSymbolInfo();
                    encoderContext.pos -= n;
                } else {
                    encoderContext.writeCodewords(string);
                }
            }
            finally {
                encoderContext.signalEncoderChange(0);
            }
        }

        protected void encodeChar(char c, StringBuffer stringBuffer) {
            if (c >= ' ' && c <= '?') {
                stringBuffer.append(c);
            } else if (c >= '@' && c <= '^') {
                stringBuffer.append((char)(c - 64));
            } else {
                DataMatrixHighLevelEncoder.illegalCharacter(c);
            }
        }

        protected String encodeToCodewords(StringBuffer stringBuffer, int n) {
            int n2 = stringBuffer.length() - n;
            if (n2 == 0) {
                throw new IllegalStateException("StringBuffer must not be empty");
            }
            char c = stringBuffer.charAt(n);
            char c2 = n2 >= 2 ? stringBuffer.charAt(n + 1) : (char)'\u0000';
            char c3 = n2 >= 3 ? stringBuffer.charAt(n + 2) : (char)'\u0000';
            char c4 = n2 >= 4 ? stringBuffer.charAt(n + 3) : (char)'\u0000';
            int n3 = (c << 18) + (c2 << 12) + (c3 << 6) + c4;
            char c5 = (char)(n3 >> 16 & 0xFF);
            char c6 = (char)(n3 >> 8 & 0xFF);
            char c7 = (char)(n3 & 0xFF);
            StringBuffer stringBuffer2 = new StringBuffer(3);
            stringBuffer2.append(c5);
            if (n2 >= 2) {
                stringBuffer2.append(c6);
            }
            if (n2 >= 3) {
                stringBuffer2.append(c7);
            }
            return stringBuffer2.toString();
        }
    }

    private static class X12Encoder
    extends C40Encoder {
        private X12Encoder() {
        }

        public int getEncodingMode() {
            return 3;
        }

        public void encode(EncoderContext encoderContext) {
            StringBuffer stringBuffer = new StringBuffer();
            while (encoderContext.hasMoreCharacters()) {
                char c = encoderContext.getCurrentChar();
                encoderContext.pos++;
                this.encodeChar(c, stringBuffer);
                int n = stringBuffer.length();
                if (n % 3 != 0) continue;
                this.writeNextTriplet(encoderContext, stringBuffer);
                int n2 = DataMatrixHighLevelEncoder.lookAheadTest(encoderContext.msg, encoderContext.pos, this.getEncodingMode());
                if (n2 == this.getEncodingMode()) continue;
                encoderContext.signalEncoderChange(n2);
                break;
            }
            this.handleEOD(encoderContext, stringBuffer);
        }

        protected int encodeChar(char c, StringBuffer stringBuffer) {
            if (c == '\r') {
                stringBuffer.append('\u0000');
            } else if (c == '*') {
                stringBuffer.append('\u0001');
            } else if (c == '>') {
                stringBuffer.append('\u0002');
            } else if (c == ' ') {
                stringBuffer.append('\u0003');
            } else if (c >= '0' && c <= '9') {
                stringBuffer.append((char)(c - 48 + 4));
            } else if (c >= 'A' && c <= 'Z') {
                stringBuffer.append((char)(c - 65 + 14));
            } else {
                DataMatrixHighLevelEncoder.illegalCharacter(c);
            }
            return 1;
        }

        protected void handleEOD(EncoderContext encoderContext, StringBuffer stringBuffer) {
            encoderContext.updateSymbolInfo();
            int n = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - encoderContext.getCodewordCount();
            int n2 = stringBuffer.length();
            if (n2 == 2) {
                encoderContext.writeCodeword('\u00fe');
                encoderContext.pos -= 2;
                encoderContext.signalEncoderChange(0);
            } else if (n2 == 1) {
                encoderContext.pos--;
                if (n > 1) {
                    encoderContext.writeCodeword('\u00fe');
                }
                encoderContext.signalEncoderChange(0);
            }
        }
    }

    private static class TextEncoder
    extends C40Encoder {
        private TextEncoder() {
        }

        public int getEncodingMode() {
            return 2;
        }

        protected int encodeChar(char c, StringBuffer stringBuffer) {
            if (c == ' ') {
                stringBuffer.append('\u0003');
                return 1;
            }
            if (c >= '0' && c <= '9') {
                stringBuffer.append((char)(c - 48 + 4));
                return 1;
            }
            if (c >= 'a' && c <= 'z') {
                stringBuffer.append((char)(c - 97 + 14));
                return 1;
            }
            if (c >= '\u0000' && c <= '\u001f') {
                stringBuffer.append('\u0000');
                stringBuffer.append(c);
                return 2;
            }
            if (c >= '!' && c <= '/') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 33));
                return 2;
            }
            if (c >= ':' && c <= '@') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 58 + 15));
                return 2;
            }
            if (c >= '[' && c <= '_') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 91 + 22));
                return 2;
            }
            if (c == '`') {
                stringBuffer.append('\u0002');
                stringBuffer.append((char)(c - 96));
                return 2;
            }
            if (c >= 'A' && c <= 'Z') {
                stringBuffer.append('\u0002');
                stringBuffer.append((char)(c - 65 + 1));
                return 2;
            }
            if (c >= '{' && c <= '\u007f') {
                stringBuffer.append('\u0002');
                stringBuffer.append((char)(c - 123 + 27));
                return 2;
            }
            if (c >= '\u0080') {
                stringBuffer.append("\u0001\u001e");
                int n = 2;
                return n += this.encodeChar((char)(c - 128), stringBuffer);
            }
            DataMatrixHighLevelEncoder.illegalCharacter(c);
            return -1;
        }
    }

    private static class C40Encoder
    implements Encoder {
        private C40Encoder() {
        }

        public int getEncodingMode() {
            return 1;
        }

        public void encode(EncoderContext encoderContext) {
            int n = -1;
            StringBuffer stringBuffer = new StringBuffer();
            while (encoderContext.hasMoreCharacters()) {
                int n2;
                char c = encoderContext.getCurrentChar();
                encoderContext.pos++;
                n = this.encodeChar(c, stringBuffer);
                int n3 = stringBuffer.length() / 3 * 2;
                int n4 = encoderContext.getCodewordCount() + n3;
                encoderContext.updateSymbolInfo(n4);
                int n5 = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - n4;
                if (!encoderContext.hasMoreCharacters()) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (stringBuffer.length() % 3 == 2 && (n5 < 2 || n5 > 2)) {
                        n = this.backtrackOneCharacter(encoderContext, stringBuffer, stringBuffer2, n);
                    }
                    while (stringBuffer.length() % 3 == 1 && (n <= 3 && n5 != 1 || n > 3)) {
                        n = this.backtrackOneCharacter(encoderContext, stringBuffer, stringBuffer2, n);
                    }
                    break;
                }
                int n6 = stringBuffer.length();
                if (n6 % 3 != 0 || (n2 = DataMatrixHighLevelEncoder.lookAheadTest(encoderContext.msg, encoderContext.pos, this.getEncodingMode())) == this.getEncodingMode()) continue;
                encoderContext.signalEncoderChange(n2);
                break;
            }
            this.handleEOD(encoderContext, stringBuffer, n);
        }

        private int backtrackOneCharacter(EncoderContext encoderContext, StringBuffer stringBuffer, StringBuffer stringBuffer2, int n) {
            int n2 = stringBuffer.length();
            stringBuffer.delete(n2 - n, n2);
            encoderContext.pos--;
            char c = encoderContext.getCurrentChar();
            n = this.encodeChar(c, stringBuffer2);
            encoderContext.resetSymbolInfo();
            return n;
        }

        protected void writeNextTriplet(EncoderContext encoderContext, StringBuffer stringBuffer) {
            encoderContext.writeCodewords(this.encodeToCodewords(stringBuffer, 0));
            stringBuffer.delete(0, 3);
        }

        protected void handleEOD(EncoderContext encoderContext, StringBuffer stringBuffer, int n) {
            int n2 = stringBuffer.length() / 3 * 2;
            int n3 = stringBuffer.length() % 3;
            int n4 = encoderContext.getCodewordCount() + n2;
            encoderContext.updateSymbolInfo(n4);
            int n5 = ((EncoderContext)encoderContext).symbolInfo.dataCapacity - n4;
            if (n3 == 2) {
                stringBuffer.append('\u0000');
                while (stringBuffer.length() >= 3) {
                    this.writeNextTriplet(encoderContext, stringBuffer);
                }
                if (encoderContext.hasMoreCharacters()) {
                    encoderContext.writeCodeword('\u00fe');
                }
            } else if (n5 == 1 && n3 == 1) {
                while (stringBuffer.length() >= 3) {
                    this.writeNextTriplet(encoderContext, stringBuffer);
                }
                if (encoderContext.hasMoreCharacters()) {
                    encoderContext.writeCodeword('\u00fe');
                }
                encoderContext.pos--;
            } else if (n3 == 0) {
                while (stringBuffer.length() >= 3) {
                    this.writeNextTriplet(encoderContext, stringBuffer);
                }
                if (n5 > 0 || encoderContext.hasMoreCharacters()) {
                    encoderContext.writeCodeword('\u00fe');
                }
            } else {
                throw new IllegalStateException("Unexpected case. Please report!");
            }
            encoderContext.signalEncoderChange(0);
        }

        protected int encodeChar(char c, StringBuffer stringBuffer) {
            if (c == ' ') {
                stringBuffer.append('\u0003');
                return 1;
            }
            if (c >= '0' && c <= '9') {
                stringBuffer.append((char)(c - 48 + 4));
                return 1;
            }
            if (c >= 'A' && c <= 'Z') {
                stringBuffer.append((char)(c - 65 + 14));
                return 1;
            }
            if (c >= '\u0000' && c <= '\u001f') {
                stringBuffer.append('\u0000');
                stringBuffer.append(c);
                return 2;
            }
            if (c >= '!' && c <= '/') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 33));
                return 2;
            }
            if (c >= ':' && c <= '@') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 58 + 15));
                return 2;
            }
            if (c >= '[' && c <= '_') {
                stringBuffer.append('\u0001');
                stringBuffer.append((char)(c - 91 + 22));
                return 2;
            }
            if (c >= '`' && c <= '\u007f') {
                stringBuffer.append('\u0002');
                stringBuffer.append((char)(c - 96));
                return 2;
            }
            if (c >= '\u0080') {
                stringBuffer.append("\u0001\u001e");
                int n = 2;
                return n += this.encodeChar((char)(c - 128), stringBuffer);
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }

        protected String encodeToCodewords(StringBuffer stringBuffer, int n) {
            char c = stringBuffer.charAt(n);
            char c2 = stringBuffer.charAt(n + 1);
            char c3 = stringBuffer.charAt(n + 2);
            int n2 = 1600 * c + 40 * c2 + c3 + 1;
            char c4 = (char)(n2 / 256);
            char c5 = (char)(n2 % 256);
            return "" + c4 + c5;
        }
    }

    private static class ASCIIEncoder
    implements Encoder {
        private ASCIIEncoder() {
        }

        public int getEncodingMode() {
            return 0;
        }

        public void encode(EncoderContext encoderContext) {
            block10: {
                char c;
                block11: {
                    block9: {
                        int n = DataMatrixHighLevelEncoder.determineConsecutiveDigitCount(encoderContext.msg, encoderContext.pos);
                        if (n < 2) break block9;
                        encoderContext.writeCodeword(DataMatrixHighLevelEncoder.encodeASCIIDigits(encoderContext.msg.charAt(encoderContext.pos), encoderContext.msg.charAt(encoderContext.pos + 1)));
                        encoderContext.pos += 2;
                        break block10;
                    }
                    c = encoderContext.getCurrentChar();
                    int n = DataMatrixHighLevelEncoder.lookAheadTest(encoderContext.msg, encoderContext.pos, this.getEncodingMode());
                    if (n == this.getEncodingMode()) break block11;
                    switch (n) {
                        case 5: {
                            encoderContext.writeCodeword('\u00e7');
                            encoderContext.signalEncoderChange(5);
                            return;
                        }
                        case 1: {
                            encoderContext.writeCodeword('\u00e6');
                            encoderContext.signalEncoderChange(1);
                            return;
                        }
                        case 3: {
                            encoderContext.writeCodeword('\u00ee');
                            encoderContext.signalEncoderChange(3);
                            break block10;
                        }
                        case 2: {
                            encoderContext.writeCodeword('\u00ef');
                            encoderContext.signalEncoderChange(2);
                            break block10;
                        }
                        case 4: {
                            encoderContext.writeCodeword('\u00f0');
                            encoderContext.signalEncoderChange(4);
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("Illegal mode: " + n);
                        }
                    }
                }
                if (DataMatrixHighLevelEncoder.isExtendedASCII(c)) {
                    encoderContext.writeCodeword('\u00eb');
                    encoderContext.writeCodeword((char)(c - 128 + 1));
                    encoderContext.pos++;
                } else {
                    encoderContext.writeCodeword((char)(c + '\u0001'));
                    encoderContext.pos++;
                }
            }
        }
    }

    private static interface Encoder {
        public int getEncodingMode();

        public void encode(EncoderContext var1);
    }

    private static class EncoderContext {
        private String msg;
        private SymbolShapeHint shape = SymbolShapeHint.FORCE_NONE;
        private Dimension minSize;
        private Dimension maxSize;
        private StringBuffer codewords;
        private int pos = 0;
        private int newEncoding = -1;
        private DataMatrixSymbolInfo symbolInfo;
        private int skipAtEnd = 0;

        public EncoderContext(String string) {
            byte[] byArray;
            try {
                byArray = string.getBytes(DataMatrixHighLevelEncoder.DEFAULT_ASCII_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new UnsupportedOperationException("Unsupported encoding: " + unsupportedEncodingException.getMessage());
            }
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                char c = (char)(byArray[i] & 0xFF);
                if (c == '?' && string.charAt(i) != '?') {
                    throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
                }
                stringBuffer.append(c);
            }
            this.msg = stringBuffer.toString();
            this.codewords = new StringBuffer(string.length());
        }

        public EncoderContext(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                char c = (char)(byArray[i] & 0xFF);
                stringBuffer.append(c);
            }
            this.msg = stringBuffer.toString();
            this.codewords = new StringBuffer(this.msg.length());
        }

        public void setSymbolShape(SymbolShapeHint symbolShapeHint) {
            this.shape = symbolShapeHint;
        }

        public void setSizeConstraints(Dimension dimension, Dimension dimension2) {
            this.minSize = dimension;
            this.maxSize = dimension2;
        }

        public String getMessage() {
            return this.msg;
        }

        public void setSkipAtEnd(int n) {
            this.skipAtEnd = n;
        }

        public char getCurrentChar() {
            return this.msg.charAt(this.pos);
        }

        public char getCurrent() {
            return this.msg.charAt(this.pos);
        }

        public void writeCodewords(String string) {
            this.codewords.append(string);
        }

        public void writeCodeword(char c) {
            this.codewords.append(c);
        }

        public int getCodewordCount() {
            return this.codewords.length();
        }

        public void signalEncoderChange(int n) {
            this.newEncoding = n;
        }

        public void resetEncoderSignal() {
            this.newEncoding = -1;
        }

        public boolean hasMoreCharacters() {
            return this.pos < this.getTotalMessageCharCount();
        }

        private int getTotalMessageCharCount() {
            return this.msg.length() - this.skipAtEnd;
        }

        public int getRemainingCharacters() {
            return this.getTotalMessageCharCount() - this.pos;
        }

        public void updateSymbolInfo() {
            this.updateSymbolInfo(this.getCodewordCount());
        }

        public void updateSymbolInfo(int n) {
            if (this.symbolInfo == null || n > this.symbolInfo.dataCapacity) {
                this.symbolInfo = DataMatrixSymbolInfo.lookup(n, this.shape, this.minSize, this.maxSize, true);
            }
        }

        public void resetSymbolInfo() {
            this.symbolInfo = null;
        }
    }
}

