/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.datamatrix;

import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixReedSolomonFactors;
import ai.org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;

public class DataMatrixErrorCorrection
implements DataMatrixReedSolomonFactors {
    private static final int MODULO_VALUE = 301;
    private static final int[] LOG = new int[256];
    private static final int[] ALOG = new int[255];

    public static String encodeECC200(String string, DataMatrixSymbolInfo dataMatrixSymbolInfo) {
        if (string.length() != dataMatrixSymbolInfo.dataCapacity) {
            throw new IllegalArgumentException("The number of codewords does not match the selected symbol");
        }
        StringBuffer stringBuffer = new StringBuffer(dataMatrixSymbolInfo.dataCapacity + dataMatrixSymbolInfo.errorCodewords);
        stringBuffer.append(string);
        int n = dataMatrixSymbolInfo.getInterleavedBlockCount();
        if (n == 1) {
            String string2 = DataMatrixErrorCorrection.createECCBlock(string, dataMatrixSymbolInfo.errorCodewords);
            stringBuffer.append(string2);
        } else {
            int n2;
            stringBuffer.setLength(stringBuffer.capacity());
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = dataMatrixSymbolInfo.getDataLengthForInterleavedBlock(n2 + 1);
                nArray2[n2] = dataMatrixSymbolInfo.getErrorLengthForInterleavedBlock(n2 + 1);
                nArray3[n2] = 0;
                if (n2 <= 0) continue;
                nArray3[n2] = nArray3[n2 - 1] + nArray[n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                StringBuffer stringBuffer2 = new StringBuffer(nArray[n2]);
                for (int i = n2; i < dataMatrixSymbolInfo.dataCapacity; i += n) {
                    stringBuffer2.append(string.charAt(i));
                }
                String string3 = DataMatrixErrorCorrection.createECCBlock(stringBuffer2.toString(), nArray2[n2]);
                int n3 = 0;
                for (int i = n2; i < nArray2[n2] * n; i += n) {
                    stringBuffer.setCharAt(dataMatrixSymbolInfo.dataCapacity + i, string3.charAt(n3++));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String createECCBlock(String string, int n) {
        return DataMatrixErrorCorrection.createECCBlock(string, 0, string.length(), n);
    }

    private static String createECCBlock(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = -1;
        for (int i = 0; i < FACTOR_SETS.length; ++i) {
            if (FACTOR_SETS[i] != n3) continue;
            n6 = i;
            break;
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Illegal number of error correction codewords specified: " + n3);
        }
        int[] nArray = DataMatrixReedSolomonFactors.FACTORS[n6];
        char[] cArray = new char[n3];
        for (n5 = 0; n5 < n3; ++n5) {
            cArray[n5] = '\u0000';
        }
        for (n5 = n; n5 < n + n2; ++n5) {
            n4 = cArray[n3 - 1] ^ string.charAt(n5);
            for (int i = n3 - 1; i > 0; --i) {
                cArray[i] = n4 != 0 && nArray[i] != 0 ? (char)(cArray[i - 1] ^ ALOG[(LOG[n4] + LOG[nArray[i]]) % 255]) : cArray[i - 1];
            }
            cArray[0] = n4 != 0 && nArray[0] != 0 ? (char)ALOG[(LOG[n4] + LOG[nArray[0]]) % 255] : (char)'\u0000';
        }
        char[] cArray2 = new char[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            cArray2[n4] = cArray[n3 - n4 - 1];
        }
        return String.valueOf(cArray2);
    }

    static {
        int n = 1;
        for (int i = 0; i < 255; ++i) {
            DataMatrixErrorCorrection.ALOG[i] = n;
            DataMatrixErrorCorrection.LOG[n] = i;
            if ((n <<= 1) < 256) continue;
            n ^= 0x12D;
        }
    }
}

