/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code39;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.code39.Code39LogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class Code39Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.19f;
    protected static final double DEFAULT_WIDE_FACTOR = 2.5;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double intercharGapWidth = this.moduleWidth = (double)0.19f;
    private double wideFactor = 2.5;
    private boolean displayStartStop = false;
    private boolean displayChecksum = false;
    private boolean extendedCharSet = false;

    public Code39Bean() {
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getIntercharGapWidth() {
        return this.intercharGapWidth;
    }

    public void setIntercharGapWidth(double d) {
        this.intercharGapWidth = d;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = d;
    }

    public boolean isDisplayStartStop() {
        return this.displayStartStop;
    }

    public void setDisplayStartStop(boolean bl) {
        this.displayStartStop = bl;
        if (bl) {
            this.setDisplayChecksum(true);
        }
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean bl) {
        if (this.isDisplayStartStop() && !bl) {
            return;
        }
        this.displayChecksum = bl;
    }

    public boolean isExtendedCharSetEnabled() {
        return this.extendedCharSet;
    }

    public void setExtendedCharSetEnabled(boolean bl) {
        this.extendedCharSet = bl;
    }

    public double getBarWidth(int n) {
        if (n == 1) {
            return this.moduleWidth;
        }
        if (n == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        if (n == -1) {
            return this.intercharGapWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler defaultCanvasLogicHandler = new DefaultCanvasLogicHandler(this, new Canvas(canvasProvider));
        Code39LogicImpl code39LogicImpl = this.createLogicImpl();
        code39LogicImpl.generateBarcodeLogic(defaultCanvasLogicHandler, string);
    }

    private Code39LogicImpl createLogicImpl() {
        return new Code39LogicImpl(this.getChecksumMode(), this.isDisplayStartStop(), this.isDisplayChecksum(), this.isExtendedCharSetEnabled());
    }

    public BarcodeDimension calcDimensions(String string) {
        Code39LogicImpl code39LogicImpl = this.createLogicImpl();
        int n = code39LogicImpl.prepareMessage(string).length();
        double d = (double)(n + 2) * (3.0 * this.wideFactor + 6.0) * this.moduleWidth + (double)(n + 1) * this.intercharGapWidth;
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(d, this.getHeight(), d + 2.0 * d2, this.getHeight(), this.quietZone, 0.0);
    }
}

