/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code39;

import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import ai.org.krysalis.barcode4j.impl.code39.Code39Bean;
import ai.org.krysalis.barcode4j.tools.Length;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class Code39
extends ConfigurableBarcodeGenerator
implements Configurable {
    public Code39() {
        this.bean = new Code39Bean();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2;
        Length length = new Length(configuration.getChild("module-width").getValue("0.19mm"), "mm");
        this.getCode39Bean().setModuleWidth(length.getValueAsMillimeter());
        super.configure(configuration);
        this.getCode39Bean().setChecksumMode(ChecksumMode.byName(configuration.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        this.getCode39Bean().setWideFactor(configuration.getChild("wide-factor").getValueAsFloat(2.5f));
        Length length2 = new Length(configuration.getChild("interchar-gap-width").getValue("1mw"), "mw");
        if (length2.getUnit().equalsIgnoreCase("mw")) {
            this.getCode39Bean().setIntercharGapWidth(length2.getValue() * this.getCode39Bean().getModuleWidth());
        } else {
            this.getCode39Bean().setIntercharGapWidth(length2.getValueAsMillimeter());
        }
        if (configuration.getChild("extended-charset", false) != null) {
            this.getCode39Bean().setExtendedCharSetEnabled(configuration.getChild("extended-charset").getValueAsBoolean());
        }
        if ((configuration2 = configuration.getChild("human-readable", false)) != null) {
            this.getCode39Bean().setDisplayStartStop(configuration2.getChild("display-start-stop").getValueAsBoolean(false));
            this.getCode39Bean().setDisplayChecksum(configuration2.getChild("display-checksum").getValueAsBoolean(false));
        }
    }

    public Code39Bean getCode39Bean() {
        return (Code39Bean)this.getBean();
    }
}

