/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import ai.org.krysalis.barcode4j.impl.code128.CheckDigit;
import ai.org.krysalis.barcode4j.impl.code128.Code128LogicImpl;
import ai.org.krysalis.barcode4j.impl.code128.DefaultCode128Encoder;
import ai.org.krysalis.barcode4j.impl.code128.EAN128AI;
import java.util.StringTokenizer;

public class EAN128LogicImpl {
    private static final byte MAX_LENGTH = 48;
    private static final byte TYPENumTestCheckDigit = 4;
    private static final byte TYPENumReplaceCheckDigit = 5;
    private static final byte TYPENumAddCheckDigit = 6;
    private EAN128AI[] ais = null;
    private char groupSeparator = (char)29;
    private char checkDigitMarker = (char)240;
    private boolean omitBrackets = false;
    private String msgCache = null;
    private StringBuffer code128Msg = new StringBuffer(48);
    private StringBuffer humanReadableMsg = new StringBuffer(48);
    private int[] encodedMsg = new int[0];
    private IllegalArgumentException exception = null;
    private boolean checksumADD = true;
    private boolean checksumCHECK = true;

    public EAN128LogicImpl(ChecksumMode checksumMode, String string, char c) {
        this.setChecksumMode(checksumMode);
        this.setTemplate(string);
        this.groupSeparator = c;
    }

    public EAN128LogicImpl(ChecksumMode checksumMode, String string) {
        this.setChecksumMode(checksumMode);
        this.setTemplate(string);
    }

    protected void setMessage(String string) {
        if (string == null || !string.equals(this.msgCache)) {
            this.code128Msg.setLength(0);
            this.humanReadableMsg.setLength(0);
            this.exception = null;
            if (string == null) {
                this.msgCache = null;
            } else {
                this.msgCache = string;
                this.code128Msg.append('\u00f1');
                this.addAIs(string);
                DefaultCode128Encoder defaultCode128Encoder = new DefaultCode128Encoder();
                this.encodedMsg = defaultCode128Encoder.encode(this.getCode128Msg());
            }
        } else if (this.exception != null) {
            throw this.exception;
        }
    }

    public String getMessage() {
        return this.msgCache;
    }

    public int[] getEncodedMessage(String string) {
        this.setMessage(string);
        return this.encodedMsg;
    }

    public void generateBarcodeLogic(ClassicBarcodeLogicHandler classicBarcodeLogicHandler, String string) {
        int n;
        this.setMessage(string);
        Code128LogicImpl code128LogicImpl = new Code128LogicImpl();
        classicBarcodeLogicHandler.startBarcode(string, this.getHumanReadableMsg());
        for (n = 0; n < this.encodedMsg.length; ++n) {
            code128LogicImpl.encodeChar(classicBarcodeLogicHandler, this.encodedMsg[n]);
        }
        n = this.encodedMsg[0];
        for (int i = 1; i < this.encodedMsg.length; ++i) {
            n += i * this.encodedMsg[i];
        }
        code128LogicImpl.encodeChar(classicBarcodeLogicHandler, n %= 103);
        code128LogicImpl.encodeStop(classicBarcodeLogicHandler);
        classicBarcodeLogicHandler.endBarcode();
    }

    public void addAIs(String string) {
        int n = 0;
        int n2 = 0;
        EAN128AI eAN128AI = null;
        while (n < string.length()) {
            if (this.ais == null) {
                eAN128AI = null;
            } else {
                try {
                    eAN128AI = this.ais[n2++];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw this.getException("Message has more AIs than template (template has " + this.ais.length + ")");
                }
            }
            n = this.addAI(string, n, eAN128AI);
        }
    }

    private int findGroupSeparator(String string, int n) {
        int n2 = string.indexOf(this.groupSeparator, n);
        if (this.groupSeparator == '\u00f1') {
            return n2;
        }
        int n3 = string.indexOf(241, n);
        if (n2 <= 0) {
            return n3;
        }
        if (n3 <= 0) {
            return n2;
        }
        return Math.min(n2, n3);
    }

    public int addAI(String string, int n, EAN128AI eAN128AI) {
        if (string == null) {
            throw this.getException("Message is empty!");
        }
        try {
            if (eAN128AI == null) {
                eAN128AI = EAN128AI.getAI(string, n);
            }
        }
        catch (Exception exception) {
            throw this.getException(exception.getMessage());
        }
        byte by = eAN128AI.lenID;
        byte by2 = eAN128AI.lenMinAll;
        byte by3 = eAN128AI.lenMaxAll;
        if (!this.omitBrackets) {
            this.humanReadableMsg.append('(');
        }
        this.humanReadableMsg.append(string.substring(n, n + by));
        this.code128Msg.append(string.substring(n, n + by));
        if (!this.omitBrackets) {
            this.humanReadableMsg.append(')');
        }
        boolean bl = false;
        int[] nArray = new int[eAN128AI.type.length + 1];
        nArray[0] = n;
        int n2 = this.findGroupSeparator(string, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 < n + by + by2) {
            if (this.checksumADD && eAN128AI.canDoChecksumADD && n2 == n + by + by2 - 1) {
                bl = true;
            } else {
                if ((eAN128AI.fixed || by2 == by3) && n2 < string.length()) {
                    throw this.getException("FNC1 not allowed in fixed length field: \"" + string.substring(n + by, Math.min(string.length(), n + by + by3)) + "\"!");
                }
                throw this.getException("Field \"" + string.substring(n + by, n2) + "\" too short! Length should be " + by2 + " at least!");
            }
        }
        if (n2 > n + by + by3) {
            if (eAN128AI.fixed || by2 == by3) {
                n2 = n + by + by3;
            } else {
                throw this.getException("Variable length field \"" + string.substring(n + by, n2) + "\" too long! Length should be " + by3 + " at the most!");
            }
        }
        int n3 = n + by;
        for (byte by4 = 0; by4 < eAN128AI.type.length; by4 = (byte)(by4 + 1)) {
            nArray[by4 + 1] = n3;
            int n4 = eAN128AI.lenMin[by4] == eAN128AI.lenMax[by4] ? n3 + eAN128AI.lenMin[by4] : n2 - eAN128AI.minLenAfterVariableLen;
            if (bl && by4 == eAN128AI.type.length - 1) {
                char c = CheckDigit.calcCheckdigit(string, nArray[eAN128AI.checkDigitStart[by4]], n3, (byte)1);
                this.humanReadableMsg.append(c);
                this.code128Msg.append(c);
                if (n2 < string.length() && this.isGroupSeparator(string.charAt(n2))) {
                    ++n2;
                }
            } else {
                this.checkType(eAN128AI, by4, string, n3, n4, nArray[eAN128AI.checkDigitStart[by4]]);
            }
            n3 = n4;
        }
        if (n2 < string.length() && this.isGroupSeparator(string.charAt(n2))) {
            ++n2;
        }
        if (!eAN128AI.fixed && n2 < string.length()) {
            this.code128Msg.append('\u00f1');
        }
        return n2;
    }

    private boolean isGroupSeparator(char c) {
        return c == this.groupSeparator || c == '\u00f1';
    }

    private void checkType(EAN128AI eAN128AI, byte by, String string, int n, int n2, int n3) {
        byte by2 = eAN128AI.type[by];
        if (by2 == 4) {
            throw this.getException("This AI is not allowed by configuration! (" + eAN128AI.toString() + ")");
        }
        if (by2 == 2) {
            for (int i = n2 - 1; i >= n; --i) {
                if (string.charAt(i) <= '\u0080' && !Character.isDigit(string.charAt(i))) continue;
                throw this.getException("Character '" + string.charAt(i) + "' must be a valid ASCII byte but not number!", string.substring(n, i));
            }
        } else if (by2 == 0) {
            for (int i = n2 - 1; i >= n; --i) {
                if (string.charAt(i) <= '\u0080') continue;
                throw this.getException("Character '" + string.charAt(i) + "' must be a valid ASCII byte!", string.substring(n, i));
            }
        } else {
            char c;
            if (eAN128AI.isCheckDigit(by) && this.checksumCHECK) {
                char c2 = CheckDigit.calcCheckdigit(string, n3, n, (byte)1);
                char c3 = string.charAt(n);
                if (c3 == this.checkDigitMarker) {
                    c3 = c2;
                }
                if (c2 != c3) {
                    throw this.getException("Checkdigit is wrong! Correct is " + c2 + " but I found " + c3 + "!");
                }
                this.humanReadableMsg.append(c2);
                this.code128Msg.append(c2);
                return;
            }
            for (c = n2 - 1; c >= n; --c) {
                if (Character.isDigit(string.charAt(c))) continue;
                throw this.getException("Character '" + string.charAt(c) + "' must be a Digit!", string.substring(n, c));
            }
            if (by2 == 3) {
                c = string.charAt(n + 2);
                char c4 = string.charAt(n + 3);
                char c5 = string.charAt(n + 4);
                char c6 = string.charAt(n + 5);
                if (c == '0' && c4 == '0' || c == '1' && c4 > '2' || c > '1') {
                    throw this.getException("Illegal Month \"" + c + c4 + "\"!", string.substring(n, n + 2));
                }
                if (c5 == '3' && c6 > '1' || c5 > '3') {
                    throw this.getException("Illegal Day \"" + c5 + c6 + "\"!", string.substring(n, n + 4));
                }
            }
        }
        this.humanReadableMsg.append(string.substring(n, n2));
        this.code128Msg.append(string.substring(n, n2));
    }

    private char getIDChar(String string, int n) {
        char c;
        try {
            c = string.charAt(n);
        }
        catch (Exception exception) {
            throw this.getException("Unable to read last ID: Message too short!");
        }
        if (!Character.isDigit(c)) {
            throw this.getException("Unable to read last ID: Characters must be numerical!");
        }
        return c;
    }

    private IllegalArgumentException getException(String string) {
        return this.getException(string, "");
    }

    private IllegalArgumentException getException(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (this.humanReadableMsg.length() > 1 || string2.length() > 0) {
            string = string + " Accepted start of Message: \"" + this.humanReadableMsg.toString() + string2 + "\"";
        }
        this.exception = new IllegalArgumentException(string);
        return this.exception;
    }

    public String getCode128Msg() {
        return this.code128Msg.toString();
    }

    public String getHumanReadableMsg() {
        return this.humanReadableMsg.toString();
    }

    public String toString() {
        return this.getHumanReadableMsg();
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        if (checksumMode == ChecksumMode.CP_AUTO) {
            this.checksumADD = true;
            this.checksumCHECK = true;
        } else if (checksumMode == ChecksumMode.CP_ADD) {
            this.checksumADD = true;
            this.checksumCHECK = false;
        } else if (checksumMode == ChecksumMode.CP_CHECK) {
            this.checksumADD = false;
            this.checksumCHECK = false;
        } else {
            this.checksumADD = false;
            this.checksumCHECK = false;
            throw new RuntimeException("Internal error");
        }
    }

    public char getGroupSeparator() {
        return this.groupSeparator;
    }

    public void setGroupSeparator(char c) {
        this.groupSeparator = c;
    }

    public void setTemplate(String string) {
        EAN128AI[] eAN128AIArray = null;
        if (string == null || string.trim().length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()", false);
        int n = stringTokenizer.countTokens();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Cannot parse template: \"" + string);
        }
        eAN128AIArray = new EAN128AI[n /= 2];
        for (int i = 0; i < n; ++i) {
            eAN128AIArray[i] = EAN128AI.parseSpec(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        this.ais = eAN128AIArray;
    }

    public char getCheckDigitMarker() {
        return this.checkDigitMarker;
    }

    public void setCheckDigitMarker(char c) {
        this.checkDigitMarker = c;
    }

    public boolean isOmitBrackets() {
        return this.omitBrackets;
    }

    public void setOmitBrackets(boolean bl) {
        this.omitBrackets = bl;
    }
}

