/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class EAN128AI {
    public static final byte CONSTLenMax = 48;
    public static final byte TYPEAlphaNum = 0;
    public static final byte TYPENum = 1;
    public static final byte TYPEAlpha = 2;
    public static final byte TYPENumDate = 3;
    public static final byte TYPEError = 4;
    public static final byte TYPECD = 5;
    private static final String[] typeToString;
    String id;
    byte lenID;
    byte lenMinAll;
    byte lenMaxAll;
    byte minLenAfterVariableLen;
    byte[] lenMin;
    byte[] lenMax;
    byte[] type;
    byte[] checkDigitStart;
    boolean fixed = false;
    boolean canDoChecksumADD = false;
    private static String[] fixedLenTable;
    private static byte[] fixedLenValueTable;
    private static EAN128AI dft;
    private static Object[] aiTable;
    private static boolean propertiesLoaded;

    private static void initFixedLen(String string, byte by) {
        byte by2 = (byte)string.length();
        EAN128AI eAN128AI = new EAN128AI(string, "an" + by, by2, 0, by);
        try {
            EAN128AI.setAI(string, eAN128AI);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadProperties() throws Exception {
        block9: {
            if (propertiesLoaded) {
                return;
            }
            AIProperties aIProperties = new AIProperties();
            try {
                InputStream inputStream = EAN128AI.class.getResourceAsStream("EAN128AIs.properties");
                if (inputStream == null) {
                    inputStream = EAN128AI.class.getClassLoader().getResourceAsStream("EAN128AIs.properties");
                }
                if (inputStream != null) {
                    try {
                        aIProperties.load(inputStream);
                        break block9;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                String string = EAN128AI.class.getPackage().getName() + "." + "EAN128AIs";
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    ((Properties)aIProperties).put(string2, resourceBundle.getObject(string2));
                }
            }
            catch (Exception exception) {
                System.err.println("EAN128AIs.properties could not be loaded!");
                exception.printStackTrace();
            }
        }
        propertiesLoaded = true;
    }

    private EAN128AI(String string, byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.id = string;
        this.lenID = by;
        this.type = byArray;
        this.lenMin = byArray2;
        this.lenMax = byArray3;
        this.checkDigitStart = byArray4;
        this.minLenAfterVariableLen = 0;
        this.lenMaxAll = 0;
        this.lenMinAll = 0;
        int n = byArray.length;
        int n2 = -1;
        for (int i = 0; i < byArray.length; ++i) {
            this.lenMinAll = (byte)(this.lenMinAll + byArray2[i]);
            this.lenMaxAll = (byte)(this.lenMaxAll + byArray3[i]);
            if (i > n) {
                this.minLenAfterVariableLen = (byte)(this.minLenAfterVariableLen + byArray2[i]);
            }
            if (byArray2[i] != byArray3[i]) {
                if (n < byArray.length) {
                    throw new IllegalArgumentException("Only one Part with var len!");
                }
                n = i;
            }
            if (n2 != -1 || byArray[i] != 5) continue;
            n2 = i;
        }
        this.canDoChecksumADD = n2 == byArray.length - 1 && this.lenMinAll == this.lenMaxAll;
    }

    private EAN128AI(String string, String string2, byte by, byte by2, byte by3) {
        this(string, by, new byte[]{by2}, new byte[]{by3}, new byte[]{by3}, new byte[]{0});
        this.fixed = true;
    }

    private static void checkFixed(EAN128AI eAN128AI, EAN128AI eAN128AI2) {
        if (eAN128AI2.fixed && !eAN128AI.fixed) {
            if (eAN128AI.lenMaxAll != eAN128AI.lenMinAll || eAN128AI.lenID + eAN128AI.lenMinAll != eAN128AI2.lenID + eAN128AI2.lenMinAll) {
                throw new IllegalArgumentException("AI \"" + eAN128AI.toString() + "\" must have fixed len: " + eAN128AI2.lenID + "+" + eAN128AI2.lenMinAll);
            }
            eAN128AI.fixed = true;
        }
    }

    private static void SetAIHere(EAN128AI eAN128AI, Object[] objectArray) {
        for (int i = 0; i <= 9; ++i) {
            EAN128AI.SetAIHere(eAN128AI, objectArray, i);
        }
    }

    private static void SetAIHere(EAN128AI eAN128AI, Object[] objectArray, int n) {
        Object object = objectArray[n];
        if (object instanceof EAN128AI) {
            EAN128AI eAN128AI2 = (EAN128AI)object;
            if (eAN128AI.type[0] == 4) {
                eAN128AI2.type[0] = 4;
            } else {
                EAN128AI.checkFixed(eAN128AI, eAN128AI2);
                objectArray[n] = eAN128AI;
            }
        } else {
            EAN128AI.SetAIHere(eAN128AI, (Object[])object);
        }
    }

    private static void setAI(String string, EAN128AI eAN128AI) {
        int n;
        Object[] objectArray = aiTable;
        for (n = string.length() - 1; n >= 0 && !Character.isDigit(string.charAt(n)); --n) {
        }
        for (int i = 0; i <= n; ++i) {
            int n2 = string.charAt(i) - 48;
            if (i == n) {
                EAN128AI.SetAIHere(eAN128AI, objectArray, n2);
                continue;
            }
            Object[] objectArray2 = objectArray[n2];
            if (objectArray2 instanceof EAN128AI) {
                objectArray[n2] = objectArray2 = new Object[]{objectArray2, objectArray2, objectArray2, objectArray2, objectArray2, objectArray2, objectArray2, objectArray2, objectArray2, objectArray2};
            }
            objectArray = objectArray2;
        }
    }

    public static EAN128AI parseSpec(String string, String string2) {
        EAN128AI eAN128AI = EAN128AI.parseSpecPrivate(string, string2);
        EAN128AI.checkAI(eAN128AI);
        return eAN128AI;
    }

    private static void parseSpecPrivate(int n, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n2 = 0;
        byArray4[n] = 1;
        byArray3[n] = -1;
        byArray2[n] = -1;
        if (string.startsWith("an")) {
            byArray[n] = 0;
            n2 = 2;
        } else if (string.startsWith("a")) {
            byArray[n] = 2;
            n2 = 1;
        } else {
            if (string.startsWith("cd")) {
                byArray[n] = 5;
                if (string.length() > 2) {
                    byArray4[n] = Byte.parseByte(string.substring(2));
                }
                byArray3[n] = 1;
                byArray2[n] = 1;
                return;
            }
            if (string.startsWith("n")) {
                byArray[n] = 1;
                n2 = 1;
            } else if (string.startsWith("d")) {
                byArray[n] = 3;
                byArray3[n] = 6;
                byArray2[n] = 6;
                n2 = 1;
            } else {
                if (string.startsWith("e")) {
                    byArray[n] = 4;
                    byArray3[n] = 0;
                    byArray2[n] = 0;
                    return;
                }
                throw new IllegalArgumentException("Unknown type!");
            }
        }
        int n3 = string.indexOf(45, n2);
        if (n3 < 0) {
            byArray2[n] = byArray3[n] = EAN128AI.parseByte(string.substring(n2), byArray2[n], string);
        } else if (n3 == n2) {
            byArray2[n] = 1;
            byArray3[n] = EAN128AI.parseByte(string.substring(n2 + 1), byArray3[n], string);
        } else {
            byArray2[n] = EAN128AI.parseByte(string.substring(n2, n3), byArray2[n], string);
            byArray3[n] = EAN128AI.parseByte(string.substring(n3 + 1), byArray3[n], string);
        }
        if (byArray[n] == 3 && (byArray2[n] != 6 || byArray3[n] != 6)) {
            throw new IllegalArgumentException("Date field (" + string + ") must have length 6!");
        }
    }

    private static byte parseByte(String string, byte by, String string2) {
        try {
            return Byte.parseByte(string);
        }
        catch (Exception exception) {
            if (by == -1) {
                throw new IllegalArgumentException("Can't read field length from \"" + string2 + "\"");
            }
            return by;
        }
    }

    private static EAN128AI parseSpecPrivate(String string, String string2) {
        try {
            byte by = (byte)string.trim().length();
            string2 = string2.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "+", false);
            int n = stringTokenizer.countTokens();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            byte[] byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                EAN128AI.parseSpecPrivate(i, stringTokenizer.nextToken(), byArray, byArray3, byArray4, byArray2);
            }
            return new EAN128AI(string, by, byArray, byArray3, byArray4, byArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot Parse AI: \"" + string + "\" spec: \"" + string2 + "\" ");
        }
    }

    public static boolean checkAI(EAN128AI eAN128AI) {
        EAN128AI eAN128AI2 = EAN128AI.getAIPrivate(eAN128AI.id + "0000", 0);
        EAN128AI.checkFixed(eAN128AI, eAN128AI2);
        return true;
    }

    public static EAN128AI getAI(String string, int n) throws Exception {
        EAN128AI.loadProperties();
        return EAN128AI.getAIPrivate(string, n);
    }

    private static EAN128AI getAIPrivate(String string, int n) {
        EAN128AI eAN128AI = dft;
        Object object = aiTable;
        for (int i = 0; i < string.length() - n; ++i) {
            int n2 = EAN128AI.getIDChar(string, n + i) - 48;
            if ((object = object[n2]) == null) {
                return dft;
            }
            if (!(object instanceof EAN128AI)) continue;
            eAN128AI = (EAN128AI)object;
            break;
        }
        return eAN128AI;
    }

    private static char getIDChar(String string, int n) {
        char c;
        try {
            c = string.charAt(n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unable to read AI: Message too short!");
        }
        if (!Character.isDigit(c)) {
            throw new IllegalArgumentException("Unable to read AI: Characters must be numerical!");
        }
        return c;
    }

    public static final boolean isCheckDigitType(byte by) {
        return by == 5;
    }

    public final boolean isCheckDigit(byte by) {
        return EAN128AI.isCheckDigitType(this.type[by]);
    }

    public static final String getType(byte by) {
        String string = "?";
        try {
            string = typeToString[by];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(this.id).append(")");
        for (int i = 0; i < this.lenMin.length; ++i) {
            if (i != 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(EAN128AI.getType(this.type[i]));
            if (this.type[i] >= 4) continue;
            stringBuffer.append(this.lenMin[i]);
            if (this.lenMin[i] == this.lenMax[i]) continue;
            stringBuffer.append('-').append(this.lenMax[i]);
        }
        stringBuffer.append(this.fixed ? " (fixed)" : "");
        return stringBuffer.toString();
    }

    static {
        int n;
        typeToString = new String[]{"an", "n", "a", "d", "e", "cd"};
        fixedLenTable = new String[]{"00", "01", "02", "03", "04", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "31", "32", "33", "34", "35", "36", "41"};
        fixedLenValueTable = new byte[]{20, 16, 16, 16, 18, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 10, 10, 10, 10, 10, 10, 16};
        dft = EAN128AI.parseSpecPrivate("xx", "an1-48");
        aiTable = new Object[]{dft, dft, dft, dft, dft, dft, dft, dft, dft, dft};
        propertiesLoaded = false;
        for (n = 0; n <= 9; ++n) {
            EAN128AI.initFixedLen("23" + n, (byte)(1 + 9 * n));
        }
        for (n = fixedLenValueTable.length - 1; n >= 0; --n) {
            EAN128AI.initFixedLen(fixedLenTable[n], (byte)(fixedLenValueTable[n] - 2));
        }
    }

    private static class AIProperties
    extends Properties {
        private AIProperties() {
        }

        public synchronized Object put(Object object, Object object2) {
            EAN128AI eAN128AI = EAN128AI.parseSpecPrivate((String)object, (String)object2);
            try {
                EAN128AI.setAI((String)object, eAN128AI);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            return super.put(object, object2);
        }
    }
}

