/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.code128;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.code128.Code128LogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class Code128Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    protected static final int DEFAULT_CODESET = 7;
    private int codeset = 7;

    public Code128Bean() {
        this.moduleWidth = 0.21f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public void setCodeset(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("At least one codeset must be allowed");
        }
        this.codeset = n;
    }

    public int getCodeset() {
        return this.codeset;
    }

    protected boolean hasFontDescender() {
        return true;
    }

    public double getBarWidth(int n) {
        if (n >= 1 && n <= 4) {
            return (double)n * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public BarcodeDimension calcDimensions(String string) {
        Code128LogicImpl code128LogicImpl = this.createLogicImpl();
        int n = 0;
        n = code128LogicImpl.createEncodedMessage(string).length + 1;
        double d = (double)(n * 11 + 13) * this.getModuleWidth();
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        double d3 = this.hasQuietZone() ? this.quietZoneVertical : 0.0;
        return new BarcodeDimension(d, this.getHeight(), d + 2.0 * d2, this.getHeight() + 2.0 * d3, d2, d3);
    }

    private Code128LogicImpl createLogicImpl() {
        return new Code128LogicImpl(this.getCodeset());
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler defaultCanvasLogicHandler = new DefaultCanvasLogicHandler(this, new Canvas(canvasProvider));
        Code128LogicImpl code128LogicImpl = this.createLogicImpl();
        code128LogicImpl.generateBarcodeLogic(defaultCanvasLogicHandler, string);
    }
}

