/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl.codabar;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.ChecksumMode;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import ai.org.krysalis.barcode4j.impl.codabar.CodabarLogicImpl;
import ai.org.krysalis.barcode4j.output.Canvas;
import ai.org.krysalis.barcode4j.output.CanvasProvider;

public class CodabarBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    protected static final double DEFAULT_WIDE_FACTOR = 3.0;
    protected static final boolean DEFAULT_DISPLAY_START_STOP = false;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private boolean displayStartStop = false;
    private double wideFactor = 3.0;

    public CodabarBean() {
        this.moduleWidth = 0.21f;
        this.setQuietZone(10.0 * this.moduleWidth);
        this.setVerticalQuietZone(0.0);
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public void setChecksumMode(ChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double d) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = d;
    }

    public double getBarWidth(int n) {
        if (n == 1) {
            return this.moduleWidth;
        }
        if (n == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public boolean isDisplayStartStop() {
        return this.displayStartStop;
    }

    public void setDisplayStartStop(boolean bl) {
        this.displayStartStop = bl;
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler defaultCanvasLogicHandler = new DefaultCanvasLogicHandler(this, new Canvas(canvasProvider));
        CodabarLogicImpl codabarLogicImpl = new CodabarLogicImpl(this.getChecksumMode(), this.isDisplayStartStop());
        codabarLogicImpl.generateBarcodeLogic(defaultCanvasLogicHandler, string);
    }

    private double calcCharWidth(char c) {
        int n = CodabarLogicImpl.getCharIndex(c);
        if (n >= 0) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 7; ++i) {
                byte by = CodabarLogicImpl.CHARSET[n][i];
                if (by == 0) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            return (double)n2 * this.moduleWidth + (double)n3 * this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Invalid character: " + c);
    }

    public BarcodeDimension calcDimensions(String string) {
        double d = 0.0;
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0) {
                d += this.moduleWidth;
            }
            d += this.calcCharWidth(string.charAt(i));
        }
        double d2 = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(d, this.getHeight(), d + 2.0 * d2, this.getHeight(), this.quietZone, 0.0);
    }
}

