/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.impl;

import ai.org.krysalis.barcode4j.BarcodeDimension;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.BarcodeUtil;
import ai.org.krysalis.barcode4j.HumanReadablePlacement;
import ai.org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import ai.org.krysalis.barcode4j.output.CanvasProvider;
import ai.org.krysalis.barcode4j.tools.Length;
import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class ConfigurableBarcodeGenerator
implements BarcodeGenerator,
Configurable {
    public static final String[] BARCODE_ELEMENTS;
    protected AbstractBarcodeBean bean;

    public void configure(Configuration configuration) throws ConfigurationException {
        Object object;
        Object object2;
        Object object3;
        Configuration configuration2 = configuration.getChild("height", false);
        if (configuration2 != null) {
            object3 = new Length(configuration2.getValue(), "mm");
            this.getBean().setHeight(((Length)object3).getValueAsMillimeter());
        }
        this.getBean().doQuietZone(configuration.getChild("quiet-zone").getAttributeAsBoolean("enabled", true));
        object3 = configuration.getChild("quiet-zone").getValue(null);
        if (object3 != null) {
            object2 = new Length((String)object3, "mw");
            if (((Length)object2).getUnit().equalsIgnoreCase("mw")) {
                this.getBean().setQuietZone(((Length)object2).getValue() * this.getBean().getModuleWidth());
            } else {
                this.getBean().setQuietZone(((Length)object2).getValueAsMillimeter());
            }
        }
        if ((object2 = configuration.getChild("vertical-quiet-zone").getValue(null)) != null) {
            object = new Length((String)object2, "in");
            if (((Length)object).getUnit().equalsIgnoreCase("mw")) {
                this.getBean().setVerticalQuietZone(((Length)object).getValue() * this.getBean().getModuleWidth());
            } else {
                this.getBean().setVerticalQuietZone(((Length)object).getValueAsMillimeter());
            }
        }
        if ((object = configuration.getChild("human-readable", false)) != null && object.getChildren().length > 0) {
            String string = object.getChild("placement").getValue(null);
            if (string != null) {
                this.getBean().setMsgPosition(HumanReadablePlacement.byName(string));
            }
            if ((configuration2 = object.getChild("font-size", false)) != null) {
                Length length = new Length(configuration2.getValue());
                this.getBean().setFontSize(length.getValueAsMillimeter());
            }
            this.getBean().setFontName(object.getChild("font-name").getValue("Helvetica"));
            this.getBean().setPattern(object.getChild("pattern").getValue(""));
        } else {
            String string = configuration.getChild("human-readable").getValue(null);
            if (string != null) {
                this.getBean().setMsgPosition(HumanReadablePlacement.byName(string));
            }
            if ((configuration2 = configuration.getChild("human-readable-size", false)) != null) {
                Length length = new Length(configuration2.getValue());
                this.getBean().setFontSize(length.getValueAsMillimeter());
            }
            this.getBean().setFontName(configuration.getChild("human-readable-font").getValue("Helvetica"));
        }
    }

    public AbstractBarcodeBean getBean() {
        return this.bean;
    }

    public void generateBarcode(CanvasProvider canvasProvider, String string) {
        this.getBean().generateBarcode(canvasProvider, string);
    }

    public BarcodeDimension calcDimensions(String string) {
        return this.getBean().calcDimensions(string);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(BarcodeUtil.getInstance().getClassResolver().getBarcodeNames());
        arrayList.add("height");
        arrayList.add("module-width");
        arrayList.add("wide-factor");
        arrayList.add("quiet-zone");
        arrayList.add("vertical-quiet-zone");
        arrayList.add("checksum");
        arrayList.add("human-readable");
        arrayList.add("human-readable-font");
        arrayList.add("human-readable-size");
        arrayList.add("font-name");
        arrayList.add("font-size");
        arrayList.add("placement");
        arrayList.add("pattern");
        arrayList.add("display-start-stop");
        arrayList.add("display-checksum");
        arrayList.add("interchar-gap-width");
        arrayList.add("tall-bar-height");
        arrayList.add("short-bar-height");
        arrayList.add("track-height");
        arrayList.add("ascender-height");
        arrayList.add("baseline-alignment");
        arrayList.add("template");
        arrayList.add("group-separator");
        arrayList.add("check-digit-marker");
        arrayList.add("omit-brackets");
        arrayList.add("shape");
        arrayList.add("row-height");
        arrayList.add("columns");
        arrayList.add("min-columns");
        arrayList.add("max-columns");
        arrayList.add("min-rows");
        arrayList.add("max-rows");
        arrayList.add("ec-level");
        arrayList.add("width-to-height-ratio");
        arrayList.add("min-symbol-size");
        arrayList.add("max-symbol-size");
        arrayList.add("codesets");
        arrayList.add("bearer-bar-width");
        arrayList.add("bearer-box");
        BARCODE_ELEMENTS = arrayList.toArray(new String[arrayList.size()]);
    }
}

