/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.cli;

import ai.org.krysalis.barcode4j.BarcodeException;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.BarcodeUtil;
import ai.org.krysalis.barcode4j.cli.AdvancedConsoleLogger;
import ai.org.krysalis.barcode4j.cli.DefaultExitHandler;
import ai.org.krysalis.barcode4j.cli.ExitHandler;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import ai.org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import ai.org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import ai.org.krysalis.barcode4j.tools.MimeTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main {
    private static final String[] APP_HEADER = new String[]{"Barcode4J command-line application, Version " + Main.getVersion(), ""};
    public static PrintStream stdout = System.out;
    public static PrintStream stderr = System.err;
    private static ExitHandler exitHandler = new DefaultExitHandler();
    private Options options;
    private boolean headerPrinted = false;
    private Logger log;

    public static void main(String[] stringArray) {
        Main main = new Main();
        main.handleCommandLine(stringArray);
    }

    public static void setExitHandler(ExitHandler exitHandler) {
        Main.exitHandler = exitHandler;
    }

    public void handleCommandLine(String[] stringArray) {
        String[] stringArray2;
        CommandLine commandLine;
        Object object;
        try {
            object = new PosixParser();
            commandLine = object.parse(this.getOptions(), stringArray);
            stringArray2 = commandLine.getArgs();
            if (stringArray2.length == 0) {
                throw new ParseException("No message");
            }
            if (stringArray2.length > 1) {
                throw new ParseException("Too many parameters: " + stringArray2.length);
            }
        }
        catch (MissingOptionException missingOptionException) {
            this.printHelp(new PrintWriter(stdout));
            exitHandler.failureExit(this, "Bad command line. Missing option: " + missingOptionException.getMessage(), null, -2);
            return;
        }
        catch (ParseException parseException) {
            this.printHelp(new PrintWriter(stdout));
            exitHandler.failureExit(this, "Bad command line: " + parseException.getMessage(), null, -2);
            return;
        }
        try {
            if (!commandLine.hasOption("o")) {
                this.log = new AdvancedConsoleLogger(3, false, stderr, stderr);
                this.printAppHeader();
                object = stdout;
            } else {
                int n = 1;
                if (commandLine.hasOption('v')) {
                    n = 0;
                }
                this.log = new AdvancedConsoleLogger(n, false, stdout, stderr);
                this.printAppHeader();
                File file = new File(commandLine.getOptionValue("o"));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Output to: " + file.getCanonicalPath());
                }
                object = new FileOutputStream(file);
            }
            this.log.debug("Message: " + stringArray2[0]);
            String string = MimeTypes.expandFormat(commandLine.getOptionValue("f", "image/svg+xml"));
            int n = 0;
            this.log.info("Generating " + string + "...");
            BarcodeUtil barcodeUtil = BarcodeUtil.getInstance();
            BarcodeGenerator barcodeGenerator = barcodeUtil.createBarcodeGenerator(this.getConfiguration(commandLine));
            if ("image/svg+xml".equals(string)) {
                SVGCanvasProvider sVGCanvasProvider = new SVGCanvasProvider(false, n);
                barcodeGenerator.generateBarcode(sVGCanvasProvider, stringArray2[0]);
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(sVGCanvasProvider.getDOMFragment());
                    StreamResult streamResult = new StreamResult((OutputStream)object);
                    transformer.transform(dOMSource, streamResult);
                }
                catch (TransformerException transformerException) {
                    exitHandler.failureExit(this, "XML/XSLT library error", transformerException, -6);
                }
            } else if ("image/x-eps".equals(string)) {
                EPSCanvasProvider ePSCanvasProvider = new EPSCanvasProvider((OutputStream)object, n);
                barcodeGenerator.generateBarcode(ePSCanvasProvider, stringArray2[0]);
                ePSCanvasProvider.finish();
            } else {
                BitmapCanvasProvider bitmapCanvasProvider;
                int n2 = Integer.parseInt(commandLine.getOptionValue('d', "300"));
                this.log.debug("Resolution: " + n2 + "dpi");
                if (commandLine.hasOption("bw")) {
                    this.log.debug("Black/white image (1-bit)");
                    bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)object, string, n2, 12, false, n);
                } else {
                    this.log.debug("Grayscale image (8-bit) with anti-aliasing");
                    bitmapCanvasProvider = new BitmapCanvasProvider((OutputStream)object, string, n2, 10, true, n);
                }
                barcodeGenerator.generateBarcode(bitmapCanvasProvider, stringArray2[0]);
                bitmapCanvasProvider.finish();
            }
            ((OutputStream)object).close();
            this.log.info("done.");
            exitHandler.successfulExit(this);
        }
        catch (IOException iOException) {
            exitHandler.failureExit(this, "Error writing output file: " + iOException.getMessage(), null, -5);
        }
        catch (ConfigurationException configurationException) {
            exitHandler.failureExit(this, "Configuration problem: " + configurationException.getMessage(), configurationException, -6);
        }
        catch (BarcodeException barcodeException) {
            exitHandler.failureExit(this, "Error generating the barcode", barcodeException, -3);
        }
    }

    private Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            OptionBuilder.withLongOpt((String)"verbose");
            OptionBuilder.withDescription((String)"enable debug output");
            this.options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"output");
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the output filename");
            this.options.addOption(OptionBuilder.create((char)'o'));
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setRequired(true);
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.withLongOpt((String)"config");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the config file");
            optionGroup.addOption(OptionBuilder.create((char)'c'));
            OptionBuilder.withArgName((String)"name");
            OptionBuilder.withLongOpt((String)"symbol");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the barcode symbology to select (default settings, use -c if you want to customize)");
            optionGroup.addOption(OptionBuilder.create((char)'s'));
            this.options.addOptionGroup(optionGroup);
            OptionBuilder.withArgName((String)"format");
            OptionBuilder.withLongOpt((String)"format");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the output format: MIME type or file extension\nDefault: image/svg+xml (SVG)");
            this.options.addOption(OptionBuilder.create((char)'f'));
            OptionBuilder.withArgName((String)"integer");
            OptionBuilder.withLongOpt((String)"dpi");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"(for bitmaps) the image resolution in dpi\nDefault: 300");
            this.options.addOption(OptionBuilder.create((char)'d'));
            OptionBuilder.withLongOpt((String)"bw");
            OptionBuilder.withDescription((String)"(for bitmaps) create monochrome (1-bit) image instead of grayscale (8-bit)");
            this.options.addOption(OptionBuilder.create());
        }
        return this.options;
    }

    private Configuration getConfiguration(CommandLine commandLine) {
        if (commandLine.hasOption("s")) {
            String string = commandLine.getOptionValue("s");
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration("cfg");
            DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration(string);
            defaultConfiguration.addChild((Configuration)defaultConfiguration2);
            return defaultConfiguration;
        }
        if (commandLine.hasOption("c")) {
            try {
                String string = commandLine.getOptionValue("c");
                File file = new File(string);
                if (!file.exists() || !file.isFile()) {
                    throw new FileNotFoundException("Config file not found: " + file);
                }
                this.log.info("Using configuration: " + file);
                DefaultConfigurationBuilder defaultConfigurationBuilder = new DefaultConfigurationBuilder();
                return defaultConfigurationBuilder.buildFromFile(file);
            }
            catch (Exception exception) {
                exitHandler.failureExit(this, "Error reading configuration file: " + exception.getMessage(), null, -3);
            }
        }
        return new DefaultConfiguration("cfg");
    }

    public static String getVersion() {
        String string = null;
        Package package_ = Main.class.getPackage();
        if (package_ != null) {
            string = package_.getImplementationVersion();
        }
        if (string == null) {
            string = "DEV";
        }
        return string;
    }

    public void printAppHeader() {
        if (!this.headerPrinted) {
            if (this.log != null) {
                for (int i = 0; i < APP_HEADER.length; ++i) {
                    this.log.info(APP_HEADER[i]);
                }
            } else {
                for (int i = 0; i < APP_HEADER.length; ++i) {
                    stdout.println(APP_HEADER[i]);
                }
            }
            this.headerPrinted = true;
        }
    }

    private void printHelp(PrintWriter printWriter) {
        this.printAppHeader();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(null);
        hashSet.add("");
        hashSet.add("image/x-png");
        hashSet.add("image/png");
        hashSet.add("image/jpeg");
        hashSet.add("image/tiff");
        hashSet.add("image/gif");
        hashSet.add("image/bmp");
        Set set = BitmapEncoderRegistry.getSupportedMIMETypes();
        set.removeAll(hashSet);
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(printWriter, 74, "java -jar barcode4j.jar [-v] [[-s <symbology>]|[-c <cfg-file>]] [-f <format>] [-d <dpi>] [-bw] [-o <file>] <message>", null, this.getOptions(), 1, 3, "\nValid output formats:\nSVG: image/svg+xml, svg\nEPS: image/x-eps, eps\nPNG: image/x-png, png" + (BitmapEncoderRegistry.supports("image/x-png") ? "" : " (unavailable)") + "\nTIFF: " + "image/tiff" + ", tiff, tif" + (BitmapEncoderRegistry.supports("image/tiff") ? "" : " (unavailable)") + "\nJPEG: " + "image/jpeg" + ", jpeg, jpg" + (BitmapEncoderRegistry.supports("image/jpeg") ? "" : " (unavailable)") + "\nGIF: " + "image/gif" + ", gif" + (BitmapEncoderRegistry.supports("image/gif") ? "" : " (unavailable)") + "\nBMP: " + "image/bmp" + ", bmp" + (BitmapEncoderRegistry.supports("image/bmp") ? "" : " (unavailable)") + (set.size() > 0 ? "\nAdditional supported formats:\n" + set : "") + "\n" + "\nIf -o is omitted the output is written to stdout.");
        printWriter.flush();
    }
}

