/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.cli;

import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;

public class AdvancedConsoleLogger
implements Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int LEVEL_DISABLED = 5;
    private static final String[] LEVEL_STRINGS = new String[]{"[DEBUG] ", "[INFO] ", "[WARN] ", "[ERROR] ", "[FATAL] "};
    private int logLevel;
    private boolean prefix;
    private PrintStream out;
    private PrintStream err;

    public AdvancedConsoleLogger(int n, boolean bl, PrintStream printStream, PrintStream printStream2) {
        this.logLevel = n;
        this.prefix = bl;
        this.out = printStream;
        this.err = printStream2;
    }

    public AdvancedConsoleLogger() {
        this(0, true, System.out, System.err);
    }

    private void logMessage(String string, Throwable throwable, int n) {
        if (n >= this.logLevel) {
            PrintStream printStream;
            PrintStream printStream2 = printStream = n >= 3 ? this.err : this.out;
            if (this.prefix) {
                printStream.print(LEVEL_STRINGS[n]);
            }
            printStream.println(string);
            if (throwable != null) {
                throwable.printStackTrace(printStream);
            }
        }
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.logMessage(string, throwable, 0);
    }

    public boolean isDebugEnabled() {
        return this.logLevel <= 0;
    }

    public void info(String string) {
        this.info(string, null);
    }

    public void info(String string, Throwable throwable) {
        this.logMessage(string, throwable, 1);
    }

    public boolean isInfoEnabled() {
        return this.logLevel <= 1;
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public void warn(String string, Throwable throwable) {
        this.logMessage(string, throwable, 2);
    }

    public boolean isWarnEnabled() {
        return this.logLevel <= 2;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Throwable throwable) {
        this.logMessage(string, throwable, 3);
    }

    public boolean isErrorEnabled() {
        return this.logLevel <= 3;
    }

    public void fatalError(String string) {
        this.fatalError(string, null);
    }

    public void fatalError(String string, Throwable throwable) {
        this.logMessage(string, throwable, 4);
    }

    public boolean isFatalErrorEnabled() {
        return this.logLevel <= 4;
    }

    public Logger getChildLogger(String string) {
        return this;
    }
}

