/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.ant;

import ai.org.krysalis.barcode4j.BarcodeException;
import ai.org.krysalis.barcode4j.BarcodeGenerator;
import ai.org.krysalis.barcode4j.BarcodeUtil;
import ai.org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import ai.org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import ai.org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import ai.org.krysalis.barcode4j.tools.MimeTypes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BarcodeTask
extends Task {
    private String symbol;
    private File configurationFile;
    private int dpi = 300;
    private String format = "image/svg+xml";
    private File output;
    private boolean bw = true;
    private String message;

    public void execute() throws BuildException {
        if (this.message == null || this.message.length() == 0) {
            throw new BuildException("No message");
        }
        if (this.output == null) {
            throw new BuildException("Output file is missing");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            this.format = MimeTypes.expandFormat(this.format);
            int n = 0;
            this.log("Generating " + this.symbol + " in " + this.format + "...");
            BarcodeUtil barcodeUtil = BarcodeUtil.getInstance();
            BarcodeGenerator barcodeGenerator = barcodeUtil.createBarcodeGenerator(this.getConfiguration());
            if ("image/svg+xml".equals(this.format)) {
                SVGCanvasProvider sVGCanvasProvider = new SVGCanvasProvider(false, n);
                barcodeGenerator.generateBarcode(sVGCanvasProvider, this.message);
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource dOMSource = new DOMSource(sVGCanvasProvider.getDOMFragment());
                    StreamResult streamResult = new StreamResult(fileOutputStream);
                    transformer.transform(dOMSource, streamResult);
                }
                catch (TransformerException transformerException) {
                    throw new BuildException("XML/XSLT library error", (Throwable)transformerException);
                }
            } else if ("image/x-eps".equals(this.format)) {
                EPSCanvasProvider ePSCanvasProvider = new EPSCanvasProvider(fileOutputStream, n);
                barcodeGenerator.generateBarcode(ePSCanvasProvider, this.message);
                ePSCanvasProvider.finish();
            } else {
                BitmapCanvasProvider bitmapCanvasProvider = this.bw ? new BitmapCanvasProvider(fileOutputStream, this.format, this.dpi, 12, false, n) : new BitmapCanvasProvider(fileOutputStream, this.format, this.dpi, 10, true, n);
                barcodeGenerator.generateBarcode(bitmapCanvasProvider, this.message);
                bitmapCanvasProvider.finish();
            }
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new BuildException("Error writing output file: " + iOException.getMessage());
        }
        catch (ConfigurationException configurationException) {
            throw new BuildException("Configuration problem: " + configurationException.getMessage(), (Throwable)configurationException);
        }
        catch (BarcodeException barcodeException) {
            throw new BuildException("Error generating the barcode", (Throwable)barcodeException);
        }
    }

    private Configuration getConfiguration() {
        if (this.symbol != null) {
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration("cfg");
            DefaultConfiguration defaultConfiguration2 = new DefaultConfiguration(this.symbol);
            defaultConfiguration.addChild((Configuration)defaultConfiguration2);
            return defaultConfiguration;
        }
        if (this.configurationFile != null) {
            try {
                if (!this.configurationFile.exists() || !this.configurationFile.isFile()) {
                    throw new BuildException("Config file not found: " + this.configurationFile);
                }
                this.log("Using configuration: " + this.configurationFile);
                DefaultConfigurationBuilder defaultConfigurationBuilder = new DefaultConfigurationBuilder();
                return defaultConfigurationBuilder.buildFromFile(this.configurationFile);
            }
            catch (Exception exception) {
                throw new BuildException("Error reading configuration file: " + exception.getMessage());
            }
        }
        return new DefaultConfiguration("cfg");
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public void setConfigurationFile(File file) {
        this.configurationFile = file;
    }

    public void setDpi(int n) {
        this.dpi = n;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setBw(boolean bl) {
        this.bw = bl;
    }

    public void setMessage(String string) {
        this.message = this.message != null ? this.message + string : string;
    }

    public void addText(String string) {
        this.message = this.message != null ? this.message + string : string;
    }
}

