/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.select;

import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.select.Collector;
import ai.org.jsoup.select.Elements;
import ai.org.jsoup.select.Evaluator;
import ai.org.jsoup.select.QueryParser;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private final Evaluator evaluator;
    private final Element root;

    private Selector(String string, Element element) {
        Validate.notNull(string);
        string = string.trim();
        Validate.notEmpty(string);
        Validate.notNull(element);
        this.evaluator = QueryParser.parse(string);
        this.root = element;
    }

    public static Elements select(String string, Element element) {
        return new Selector(string, element).select();
    }

    public static Elements select(String string, Iterable<Element> iterable) {
        Validate.notEmpty(string);
        Validate.notNull(iterable);
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Element element : iterable) {
            linkedHashSet.addAll(Selector.select(string, element));
        }
        return new Elements(linkedHashSet);
    }

    private Elements select() {
        return Collector.collect(this.evaluator, this.root);
    }

    static Elements filterOut(Collection<Element> collection, Collection<Element> collection2) {
        Elements elements = new Elements();
        for (Element element : collection) {
            boolean bl = false;
            for (Element element2 : collection2) {
                if (!element.equals(element2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            elements.add(element);
        }
        return elements;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String string, Object ... objectArray) {
            super(String.format(string, objectArray));
        }
    }
}

