/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.helper.Validate;
import ai.org.jsoup.nodes.Comment;
import ai.org.jsoup.nodes.DocumentType;
import ai.org.jsoup.nodes.Element;
import ai.org.jsoup.nodes.Node;
import ai.org.jsoup.nodes.TextNode;
import ai.org.jsoup.nodes.XmlDeclaration;
import ai.org.jsoup.parser.ParseErrorList;
import ai.org.jsoup.parser.Tag;
import ai.org.jsoup.parser.Token;
import ai.org.jsoup.parser.TreeBuilder;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    protected void initialiseParse(String string, String string2, ParseErrorList parseErrorList) {
        super.initialiseParse(string, string2, parseErrorList);
        this.stack.add(this.doc);
    }

    @Override
    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag) {
        Tag tag = Tag.valueOf(startTag.name());
        Element element = new Element(tag, this.baseUri, startTag.attributes);
        this.insertNode(element);
        if (startTag.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(element);
        }
        return element;
    }

    void insert(Token.Comment comment) {
        String string;
        Comment comment2;
        Node node = comment2 = new Comment(comment.getData(), this.baseUri);
        if (comment.bogus && (string = comment2.getData()).length() > 1 && (string.startsWith("!") || string.startsWith("?"))) {
            String string2 = string.substring(1);
            node = new XmlDeclaration(string2, comment2.baseUri(), string.startsWith("!"));
        }
        this.insertNode(node);
    }

    void insert(Token.Character character) {
        TextNode textNode = new TextNode(character.getData(), this.baseUri);
        this.insertNode(textNode);
    }

    void insert(Token.Doctype doctype) {
        DocumentType documentType = new DocumentType(doctype.getName(), doctype.getPublicIdentifier(), doctype.getSystemIdentifier(), this.baseUri);
        this.insertNode(documentType);
    }

    private void popStackToClose(Token.EndTag endTag) {
        Element element;
        String string = endTag.name();
        Element element2 = null;
        Iterator iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!element.nodeName().equals(string)) continue;
            element2 = element;
            break;
        }
        if (element2 == null) {
            return;
        }
        iterator = this.stack.descendingIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (element == element2) {
                iterator.remove();
                break;
            }
            iterator.remove();
        }
    }

    List<Node> parseFragment(String string, String string2, ParseErrorList parseErrorList) {
        this.initialiseParse(string, string2, parseErrorList);
        this.runParser();
        return this.doc.childNodes();
    }
}

