/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jsoup.parser;

import ai.org.jsoup.helper.StringUtil;
import ai.org.jsoup.helper.Validate;

public class TokenQueue {
    private String queue;
    private int pos = 0;
    private static final char ESC = '\\';

    public TokenQueue(String string) {
        Validate.notNull(string);
        this.queue = string;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    public char peek() {
        return this.isEmpty() ? (char)'\u0000' : this.queue.charAt(this.pos);
    }

    public void addFirst(Character c) {
        this.addFirst(c.toString());
    }

    public void addFirst(String string) {
        this.queue = string + this.queue.substring(this.pos);
        this.pos = 0;
    }

    public boolean matches(String string) {
        return this.queue.regionMatches(true, this.pos, string, 0, string.length());
    }

    public boolean matchesCS(String string) {
        return this.queue.startsWith(string, this.pos);
    }

    public boolean matchesAny(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.matches(string)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        for (char c : cArray) {
            if (this.queue.charAt(this.pos) != c) continue;
            return true;
        }
        return false;
    }

    public boolean matchesStartTag() {
        return this.remainingLength() >= 2 && this.queue.charAt(this.pos) == '<' && Character.isLetter(this.queue.charAt(this.pos + 1));
    }

    public boolean matchChomp(String string) {
        if (this.matches(string)) {
            this.pos += string.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.queue.charAt(this.pos));
    }

    public void advance() {
        if (!this.isEmpty()) {
            ++this.pos;
        }
    }

    public char consume() {
        return this.queue.charAt(this.pos++);
    }

    public void consume(String string) {
        if (!this.matches(string)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int n = string.length();
        if (n > this.remainingLength()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        this.pos += n;
    }

    public String consumeTo(String string) {
        int n = this.queue.indexOf(string, this.pos);
        if (n != -1) {
            String string2 = this.queue.substring(this.pos, n);
            this.pos += string2.length();
            return string2;
        }
        return this.remainder();
    }

    public String consumeToIgnoreCase(String string) {
        int n = this.pos;
        String string2 = string.substring(0, 1);
        boolean bl = string2.toLowerCase().equals(string2.toUpperCase());
        while (!this.isEmpty() && !this.matches(string)) {
            if (bl) {
                int n2 = this.queue.indexOf(string2, this.pos) - this.pos;
                if (n2 == 0) {
                    ++this.pos;
                    continue;
                }
                if (n2 < 0) {
                    this.pos = this.queue.length();
                    continue;
                }
                this.pos += n2;
                continue;
            }
            ++this.pos;
        }
        String string3 = this.queue.substring(n, this.pos);
        return string3;
    }

    public String consumeToAny(String ... stringArray) {
        int n = this.pos;
        while (!this.isEmpty() && !this.matchesAny(stringArray)) {
            ++this.pos;
        }
        String string = this.queue.substring(n, this.pos);
        return string;
    }

    public String chompTo(String string) {
        String string2 = this.consumeTo(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompToIgnoreCase(String string) {
        String string2 = this.consumeToIgnoreCase(string);
        this.matchChomp(string);
        return string2;
    }

    public String chompBalanced(char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (!this.isEmpty()) {
            Character c3 = Character.valueOf(this.consume());
            if (n2 == 0 || n2 != 92) {
                if (c3.equals(Character.valueOf(c))) {
                    ++n;
                } else if (c3.equals(Character.valueOf(c2))) {
                    --n;
                }
            }
            if (n > 0 && n2 != 0) {
                stringBuilder.append(c3);
            }
            n2 = c3.charValue();
            if (n > 0) continue;
        }
        return stringBuilder.toString();
    }

    public static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        for (char c2 : string.toCharArray()) {
            if (c2 == '\\') {
                if (c != '\u0000' && c == '\\') {
                    stringBuilder.append(c2);
                }
            } else {
                stringBuilder.append(c2);
            }
            c = c2;
        }
        return stringBuilder.toString();
    }

    public boolean consumeWhitespace() {
        boolean bl = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            bl = true;
        }
        return bl;
    }

    public String consumeWord() {
        int n = this.pos;
        while (this.matchesWord()) {
            ++this.pos;
        }
        return this.queue.substring(n, this.pos);
    }

    public String consumeTagName() {
        int n = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny(':', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(n, this.pos);
    }

    public String consumeElementSelector() {
        int n = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('|', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(n, this.pos);
    }

    public String consumeCssIdentifier() {
        int n = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_'))) {
            ++this.pos;
        }
        return this.queue.substring(n, this.pos);
    }

    public String consumeAttributeKey() {
        int n = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAny('-', '_', ':'))) {
            ++this.pos;
        }
        return this.queue.substring(n, this.pos);
    }

    public String remainder() {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.isEmpty()) {
            stringBuilder.append(this.consume());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.queue.substring(this.pos);
    }
}

