/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.factory.objects;

import ai.org.jfree.io.IOUtils;
import ai.org.jfree.util.Log;
import ai.org.jfree.xml.factory.objects.AbstractObjectDescription;
import ai.org.jfree.xml.factory.objects.ObjectFactoryException;
import java.net.URL;

public class URLObjectDescription
extends AbstractObjectDescription {
    public URLObjectDescription() {
        super(URL.class);
        this.setParameterDefinition("value", String.class);
    }

    public Object createObject() {
        String string = (String)this.getParameter("value");
        String string2 = this.getConfig().getConfigProperty("content-base");
        try {
            URL uRL = new URL(string2);
            return new URL(uRL, string);
        }
        catch (Exception exception) {
            try {
                Log.warn("BaseURL is invalid: ", exception);
                return new URL(string);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (!(object instanceof URL)) {
            throw new ObjectFactoryException("Is no instance of java.net.URL");
        }
        URL uRL = (URL)object;
        String string = this.getConfig().getConfigProperty("content-base");
        try {
            URL uRL2 = new URL(string);
            this.setParameter("value", IOUtils.getInstance().createRelativeURL(uRL, uRL2));
        }
        catch (Exception exception) {
            Log.warn("BaseURL is invalid: ", exception);
        }
        this.setParameter("value", uRL.toExternalForm());
    }
}

