/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.factory.objects;

import ai.org.jfree.util.Configuration;
import ai.org.jfree.xml.factory.objects.ClassFactory;
import ai.org.jfree.xml.factory.objects.ClassFactoryImpl;
import ai.org.jfree.xml.factory.objects.ObjectDescription;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassFactoryCollector
extends ClassFactoryImpl {
    private ArrayList factories = new ArrayList();

    public void addFactory(ClassFactory classFactory) {
        this.factories.add(classFactory);
        if (this.getConfig() != null) {
            classFactory.configure(this.getConfig());
        }
    }

    public Iterator getFactories() {
        return this.factories.iterator();
    }

    public ObjectDescription getDescriptionForClass(Class clazz) {
        for (int i = 0; i < this.factories.size(); ++i) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(i);
            ObjectDescription objectDescription = classFactory.getDescriptionForClass(clazz);
            if (objectDescription == null) continue;
            return objectDescription;
        }
        return super.getDescriptionForClass(clazz);
    }

    public ObjectDescription getSuperClassObjectDescription(Class clazz, ObjectDescription objectDescription) {
        for (int i = 0; i < this.factories.size(); ++i) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(i);
            ObjectDescription objectDescription2 = classFactory.getSuperClassObjectDescription(clazz, objectDescription);
            if (objectDescription2 == null) continue;
            if (objectDescription == null) {
                objectDescription = objectDescription2;
                continue;
            }
            if (!this.getComparator().isComparable(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) || this.getComparator().compare(objectDescription.getObjectClass(), objectDescription2.getObjectClass()) >= 0) continue;
            objectDescription = objectDescription2;
        }
        return super.getSuperClassObjectDescription(clazz, objectDescription);
    }

    public Iterator getRegisteredClasses() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.factories.size(); ++i) {
            ClassFactory classFactory = (ClassFactory)this.factories.get(i);
            Iterator iterator = classFactory.getRegisteredClasses();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList.iterator();
    }

    public void configure(Configuration configuration) {
        if (this.getConfig() != null) {
            return;
        }
        super.configure(configuration);
        for (ClassFactory classFactory : this.factories) {
            classFactory.configure(configuration);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassFactoryCollector)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ClassFactoryCollector classFactoryCollector = (ClassFactoryCollector)object;
        return this.factories.equals(classFactoryCollector.factories);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + this.factories.hashCode();
        return n;
    }
}

