/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.xml.factory.objects;

import ai.org.jfree.xml.factory.objects.AbstractObjectDescription;
import ai.org.jfree.xml.factory.objects.ObjectFactoryException;
import java.awt.BasicStroke;

public class BasicStrokeObjectDescription
extends AbstractObjectDescription {
    public BasicStrokeObjectDescription() {
        super(BasicStroke.class);
        this.setParameterDefinition("value", String.class);
        this.setParameterDefinition("width", Float.class);
        this.setParameterDefinition("dashes", Float[].class);
    }

    private float getFloatParameter(String string) {
        String string2 = (String)this.getParameter(string);
        if (string2 == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public Object createObject() {
        float f = this.getFloatParameter("value");
        if (f > 0.0f) {
            return new BasicStroke(f);
        }
        Float f2 = (Float)this.getParameter("width");
        Float[] floatArray = (Float[])this.getParameter("dashes");
        if (f2 == null || floatArray == null) {
            return null;
        }
        float[] fArray = new float[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            Float f3 = floatArray[i];
            fArray[i] = f3.floatValue();
        }
        return new BasicStroke(f2.floatValue(), 2, 0, 10.0f, fArray, 0.0f);
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (!(object instanceof BasicStroke)) {
            throw new ObjectFactoryException("Expected object of type BasicStroke");
        }
        BasicStroke basicStroke = (BasicStroke)object;
        this.setParameter("value", String.valueOf(basicStroke.getLineWidth()));
    }
}

