/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util.junit;

import ai.org.jfree.util.ShapeList;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ShapeListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ShapeListTests.class);
    }

    public ShapeListTests(String string) {
        super(string);
    }

    public void testEquals() {
        ShapeList shapeList = new ShapeList();
        shapeList.setShape(0, new Rectangle(1, 2, 3, 4));
        shapeList.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        shapeList.setShape(2, null);
        ShapeList shapeList2 = new ShapeList();
        shapeList2.setShape(0, new Rectangle(1, 2, 3, 4));
        shapeList2.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        shapeList2.setShape(2, null);
        ShapeListTests.assertTrue((boolean)shapeList.equals(shapeList2));
        ShapeListTests.assertTrue((boolean)shapeList2.equals(shapeList2));
    }

    public void testCloning() {
        ShapeList shapeList = new ShapeList();
        shapeList.setShape(0, new Rectangle(1, 2, 3, 4));
        shapeList.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        shapeList.setShape(2, null);
        ShapeList shapeList2 = null;
        try {
            shapeList2 = (ShapeList)shapeList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        ShapeListTests.assertTrue((shapeList != shapeList2 ? 1 : 0) != 0);
        ShapeListTests.assertTrue((shapeList.getClass() == shapeList2.getClass() ? 1 : 0) != 0);
        ShapeListTests.assertTrue((boolean)shapeList.equals(shapeList2));
        shapeList2.setShape(0, new Rectangle(5, 6, 7, 8));
        ShapeListTests.assertFalse((boolean)shapeList.equals(shapeList2));
    }

    public void testSerialization() {
        ShapeList shapeList = new ShapeList();
        shapeList.setShape(0, new Rectangle(1, 2, 3, 4));
        shapeList.setShape(1, new Line2D.Double(1.0, 2.0, 3.0, 4.0));
        shapeList.setShape(2, null);
        ShapeList shapeList2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(shapeList);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            shapeList2 = (ShapeList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ShapeListTests.assertEquals((Object)shapeList, shapeList2);
    }
}

