/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util.junit;

import ai.org.jfree.util.BooleanList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BooleanListTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(BooleanListTests.class);
    }

    public BooleanListTests(String string) {
        super(string);
    }

    public void testEquals() {
        BooleanList booleanList = new BooleanList();
        booleanList.setBoolean(0, Boolean.TRUE);
        booleanList.setBoolean(1, Boolean.FALSE);
        booleanList.setBoolean(2, null);
        BooleanList booleanList2 = new BooleanList();
        booleanList2.setBoolean(0, Boolean.TRUE);
        booleanList2.setBoolean(1, Boolean.FALSE);
        booleanList2.setBoolean(2, null);
        BooleanListTests.assertTrue((boolean)booleanList.equals(booleanList2));
        BooleanListTests.assertTrue((boolean)booleanList2.equals(booleanList2));
    }

    public void testCloning() {
        BooleanList booleanList = new BooleanList();
        booleanList.setBoolean(0, Boolean.TRUE);
        booleanList.setBoolean(1, Boolean.FALSE);
        booleanList.setBoolean(2, null);
        BooleanList booleanList2 = null;
        try {
            booleanList2 = (BooleanList)booleanList.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("BooleanListTests.testCloning: failed to clone.");
        }
        BooleanListTests.assertTrue((booleanList != booleanList2 ? 1 : 0) != 0);
        BooleanListTests.assertTrue((booleanList.getClass() == booleanList2.getClass() ? 1 : 0) != 0);
        BooleanListTests.assertTrue((boolean)booleanList.equals(booleanList2));
        booleanList2.setBoolean(0, Boolean.FALSE);
        BooleanListTests.assertFalse((boolean)booleanList.equals(booleanList2));
    }

    public void testSerialization() {
        BooleanList booleanList = new BooleanList();
        booleanList.setBoolean(0, Boolean.TRUE);
        booleanList.setBoolean(1, Boolean.FALSE);
        booleanList.setBoolean(2, null);
        BooleanList booleanList2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(booleanList);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            booleanList2 = (BooleanList)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        BooleanListTests.assertEquals((Object)booleanList, booleanList2);
    }
}

