/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.util;

import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.AbstractObjectList;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ShapeList
extends AbstractObjectList {
    public Shape getShape(int n) {
        return (Shape)this.get(n);
    }

    public void setShape(int n, Shape shape) {
        this.set(n, shape);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ShapeList)) {
            return false;
        }
        ShapeList shapeList = (ShapeList)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (ShapeUtilities.equal((Shape)this.get(i), (Shape)shapeList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Shape shape = this.getShape(i);
            if (shape != null) {
                objectOutputStream.writeInt(i);
                SerialUtilities.writeShape(shape, objectOutputStream);
                continue;
            }
            objectOutputStream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = objectInputStream.readInt();
            if (n2 == -1) continue;
            this.setShape(n2, SerialUtilities.readShape(objectInputStream));
        }
    }
}

