/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui.junit;

import ai.org.jfree.ui.LengthAdjustmentType;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.UnitType;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RectangleInsetsTests
extends TestCase {
    private static final double EPSILON = 1.0E-7;

    public static Test suite() {
        return new TestSuite(RectangleInsetsTests.class);
    }

    public RectangleInsetsTests(String string) {
        super(string);
    }

    public void testCreateAdjustedRectangleAbsolute() {
        RectangleInsets rectangleInsets = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0);
        Rectangle2D rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(10.0, 19.0, 30.0, 44.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(10.0, 21.0, 30.0, 36.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(8.0, 20.0, 36.0, 40.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(12.0, 20.0, 24.0, 40.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(8.0, 19.0, 36.0, 44.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(8.0, 21.0, 36.0, 36.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(12.0, 21.0, 24.0, 36.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(12.0, 19.0, 24.0, 44.0), (Object)rectangle2D);
    }

    public void testCreateAdjustedRectangleRelative() {
        RectangleInsets rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.04, 0.03, 0.02, 0.01);
        Rectangle2D.Double double_ = new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0);
        Rectangle2D rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((Object)new Rectangle2D.Double(10.0, 20.0, 30.0, 40.0), (Object)rectangle2D);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((double)10.0, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)18.2978723404, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)30.0, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)42.553191489, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.NO_CHANGE, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((double)10.0, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)21.6, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)30.0, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)37.6, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((double)9.0625, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)20.0, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)31.25, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)40.0, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.NO_CHANGE);
        RectangleInsetsTests.assertEquals((double)10.9, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)20.0, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)28.8, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)40.0, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((double)9.0625, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)18.2978723404, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)31.25, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)42.553191489, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.EXPAND, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((double)9.0625, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)21.6, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)31.25, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)37.6, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.CONTRACT);
        RectangleInsetsTests.assertEquals((double)10.9, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)21.6, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)28.8, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)37.6, (double)rectangle2D.getHeight(), (double)1.0E-7);
        rectangle2D = rectangleInsets.createAdjustedRectangle(double_, LengthAdjustmentType.CONTRACT, LengthAdjustmentType.EXPAND);
        RectangleInsetsTests.assertEquals((double)10.9, (double)rectangle2D.getX(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)18.2978723404, (double)rectangle2D.getY(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)28.8, (double)rectangle2D.getWidth(), (double)1.0E-7);
        RectangleInsetsTests.assertEquals((double)42.553191489, (double)rectangle2D.getHeight(), (double)1.0E-7);
    }

    public void testEquals() {
        RectangleInsets rectangleInsets = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets rectangleInsets2 = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets2.equals(rectangleInsets));
        rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets2 = new RectangleInsets(UnitType.RELATIVE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 2.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        RectangleInsetsTests.assertFalse((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 3.0, 4.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        RectangleInsetsTests.assertFalse((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 4.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        RectangleInsetsTests.assertFalse((boolean)rectangleInsets.equals(rectangleInsets2));
        rectangleInsets2 = new RectangleInsets(UnitType.RELATIVE, 0.0, 0.0, 0.0, 0.0);
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
    }

    public void testSerialization() {
        RectangleInsets rectangleInsets = new RectangleInsets(UnitType.ABSOLUTE, 1.0, 2.0, 3.0, 4.0);
        RectangleInsets rectangleInsets2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(rectangleInsets);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            rectangleInsets2 = (RectangleInsets)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RectangleInsetsTests.assertTrue((boolean)rectangleInsets.equals(rectangleInsets2));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RectangleInsetsTests.suite());
    }
}

