/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui;

import ai.org.jfree.ui.L1R3ButtonPanel;
import ai.org.jfree.ui.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class WizardDialog
extends JDialog
implements ActionListener {
    private Object result = null;
    private int step;
    private WizardPanel currentPanel;
    private List panels;
    private JButton previousButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton helpButton;

    public WizardDialog(JDialog jDialog, boolean bl, String string, WizardPanel wizardPanel) {
        super(jDialog, string + " : step 1", bl);
        this.currentPanel = wizardPanel;
        this.step = 0;
        this.panels = new ArrayList();
        this.panels.add(wizardPanel);
        this.setContentPane(this.createContent());
    }

    public WizardDialog(JFrame jFrame, boolean bl, String string, WizardPanel wizardPanel) {
        super(jFrame, string + " : step 1", bl);
        this.currentPanel = wizardPanel;
        this.step = 0;
        this.panels = new ArrayList();
        this.panels.add(wizardPanel);
        this.setContentPane(this.createContent());
    }

    public Object getResult() {
        return this.result;
    }

    public int getStepCount() {
        return 0;
    }

    public boolean canDoPreviousPanel() {
        return this.step > 0;
    }

    public boolean canDoNextPanel() {
        return this.currentPanel.hasNextPanel();
    }

    public boolean canFinish() {
        return this.currentPanel.canFinish();
    }

    public WizardPanel getWizardPanel(int n) {
        if (n < this.panels.size()) {
            return (WizardPanel)this.panels.get(n);
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("nextButton")) {
            this.next();
        } else if (string.equals("previousButton")) {
            this.previous();
        } else if (string.equals("finishButton")) {
            this.finish();
        }
    }

    public void previous() {
        if (this.step > 0) {
            WizardPanel wizardPanel = this.getWizardPanel(this.step - 1);
            wizardPanel.returnFromLaterStep();
            Container container = this.getContentPane();
            container.remove(this.currentPanel);
            container.add(wizardPanel);
            --this.step;
            this.currentPanel = wizardPanel;
            this.setTitle("Step " + (this.step + 1));
            this.enableButtons();
            this.pack();
        }
    }

    public void next() {
        WizardPanel wizardPanel = this.getWizardPanel(this.step + 1);
        if (wizardPanel != null) {
            if (!this.currentPanel.canRedisplayNextPanel()) {
                wizardPanel = this.currentPanel.getNextPanel();
            }
        } else {
            wizardPanel = this.currentPanel.getNextPanel();
        }
        ++this.step;
        if (this.step < this.panels.size()) {
            this.panels.set(this.step, wizardPanel);
        } else {
            this.panels.add(wizardPanel);
        }
        Container container = this.getContentPane();
        container.remove(this.currentPanel);
        container.add(wizardPanel);
        this.currentPanel = wizardPanel;
        this.setTitle("Step " + (this.step + 1));
        this.enableButtons();
        this.pack();
    }

    public void finish() {
        this.result = this.currentPanel.getResult();
        this.setVisible(false);
    }

    private void enableButtons() {
        this.previousButton.setEnabled(this.step > 0);
        this.nextButton.setEnabled(this.canDoNextPanel());
        this.finishButton.setEnabled(this.canFinish());
        this.helpButton.setEnabled(false);
    }

    public boolean isCancelled() {
        return false;
    }

    public JPanel createContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add((JPanel)this.panels.get(0));
        L1R3ButtonPanel l1R3ButtonPanel = new L1R3ButtonPanel("Help", "Previous", "Next", "Finish");
        this.helpButton = l1R3ButtonPanel.getLeftButton();
        this.helpButton.setEnabled(false);
        this.previousButton = l1R3ButtonPanel.getRightButton1();
        this.previousButton.setActionCommand("previousButton");
        this.previousButton.addActionListener(this);
        this.previousButton.setEnabled(false);
        this.nextButton = l1R3ButtonPanel.getRightButton2();
        this.nextButton.setActionCommand("nextButton");
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(true);
        this.finishButton = l1R3ButtonPanel.getRightButton3();
        this.finishButton.setActionCommand("finishButton");
        this.finishButton.addActionListener(this);
        this.finishButton.setEnabled(false);
        l1R3ButtonPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jPanel.add((Component)l1R3ButtonPanel, "South");
        return jPanel;
    }
}

