/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui;

import ai.org.jfree.date.SerialDate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SerialDateChooserPanel
extends JPanel
implements ActionListener {
    public static final Color DEFAULT_DATE_BUTTON_COLOR = Color.red;
    public static final Color DEFAULT_MONTH_BUTTON_COLOR = Color.lightGray;
    private SerialDate date;
    private Color dateButtonColor;
    private Color monthButtonColor;
    private Color chosenOtherButtonColor = Color.darkGray;
    private int firstDayOfWeek = 1;
    private int yearSelectionRange = 20;
    private Font dateFont = new Font("SansSerif", 0, 10);
    private JComboBox monthSelector = null;
    private JComboBox yearSelector = null;
    private JButton todayButton = null;
    private JButton[] buttons = null;
    private boolean refreshing = false;

    public SerialDateChooserPanel() {
        this(SerialDate.createInstance(new Date()), false, DEFAULT_DATE_BUTTON_COLOR, DEFAULT_MONTH_BUTTON_COLOR);
    }

    public SerialDateChooserPanel(SerialDate serialDate, boolean bl) {
        this(serialDate, bl, DEFAULT_DATE_BUTTON_COLOR, DEFAULT_MONTH_BUTTON_COLOR);
    }

    public SerialDateChooserPanel(SerialDate serialDate, boolean bl, Color color, Color color2) {
        super(new BorderLayout());
        this.date = serialDate;
        this.dateButtonColor = color;
        this.monthButtonColor = color2;
        this.add((Component)this.constructSelectionPanel(), "North");
        this.add((Component)this.getCalendarPanel(), "Center");
        if (bl) {
            this.add((Component)this.constructControlPanel(), "South");
        }
    }

    public void setDate(SerialDate serialDate) {
        this.date = serialDate;
        this.monthSelector.setSelectedIndex(serialDate.getMonth() - 1);
        this.refreshYearSelector();
        this.refreshButtons();
    }

    public SerialDate getDate() {
        return this.date;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("monthSelectionChanged")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.date = SerialDate.createInstance(this.date.getDayOfMonth(), jComboBox.getSelectedIndex() + 1, this.date.getYYYY());
            this.refreshButtons();
        } else if (actionEvent.getActionCommand().equals("yearSelectionChanged")) {
            if (!this.refreshing) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Integer n = (Integer)jComboBox.getSelectedItem();
                this.date = SerialDate.createInstance(this.date.getDayOfMonth(), this.date.getMonth(), n);
                this.refreshYearSelector();
                this.refreshButtons();
            }
        } else if (actionEvent.getActionCommand().equals("todayButtonClicked")) {
            this.setDate(SerialDate.createInstance(new Date()));
        } else if (actionEvent.getActionCommand().equals("dateButtonClicked")) {
            JButton jButton = (JButton)actionEvent.getSource();
            int n = Integer.parseInt(jButton.getName());
            SerialDate serialDate = this.getFirstVisibleDate();
            SerialDate serialDate2 = SerialDate.addDays(n, serialDate);
            this.setDate(serialDate2);
        }
    }

    private JPanel getCalendarPanel() {
        JPanel jPanel = new JPanel(new GridLayout(7, 7));
        jPanel.add(new JLabel("Sun", 0));
        jPanel.add(new JLabel("Mon", 0));
        jPanel.add(new JLabel("Tue", 0));
        jPanel.add(new JLabel("Wed", 0));
        jPanel.add(new JLabel("Thu", 0));
        jPanel.add(new JLabel("Fri", 0));
        jPanel.add(new JLabel("Sat", 0));
        this.buttons = new JButton[42];
        for (int i = 0; i < 42; ++i) {
            JButton jButton = new JButton("");
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.setName(Integer.toString(i));
            jButton.setFont(this.dateFont);
            jButton.setFocusPainted(false);
            jButton.setActionCommand("dateButtonClicked");
            jButton.addActionListener(this);
            this.buttons[i] = jButton;
            jPanel.add(jButton);
        }
        return jPanel;
    }

    protected Color getButtonColor(SerialDate serialDate) {
        if (this.date.equals(this.date)) {
            return this.dateButtonColor;
        }
        if (serialDate.getMonth() == this.date.getMonth()) {
            return this.monthButtonColor;
        }
        return this.chosenOtherButtonColor;
    }

    protected SerialDate getFirstVisibleDate() {
        SerialDate serialDate = SerialDate.createInstance(1, this.date.getMonth(), this.date.getYYYY());
        serialDate = SerialDate.addDays(-1, serialDate);
        while (serialDate.getDayOfWeek() != this.getFirstDayOfWeek()) {
            serialDate = SerialDate.addDays(-1, serialDate);
        }
        return serialDate;
    }

    private int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    protected void refreshButtons() {
        SerialDate serialDate = this.getFirstVisibleDate();
        for (int i = 0; i < 42; ++i) {
            JButton jButton = this.buttons[i];
            jButton.setText(String.valueOf(serialDate.getDayOfWeek()));
            jButton.setBackground(this.getButtonColor(serialDate));
            serialDate = SerialDate.addDays(1, serialDate);
        }
    }

    private void refreshYearSelector() {
        if (!this.refreshing) {
            this.refreshing = true;
            this.yearSelector.removeAllItems();
            Vector vector = this.getYears(this.date.getYYYY());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.yearSelector.addItem(enumeration.nextElement());
            }
            this.yearSelector.setSelectedItem(new Integer(this.date.getYYYY()));
            this.refreshing = false;
        }
    }

    private Vector getYears(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = n - this.yearSelectionRange; i <= n + this.yearSelectionRange; ++i) {
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    private JPanel constructSelectionPanel() {
        JPanel jPanel = new JPanel();
        this.monthSelector = new JComboBox<String>(SerialDate.getMonths());
        this.monthSelector.addActionListener(this);
        this.monthSelector.setActionCommand("monthSelectionChanged");
        jPanel.add(this.monthSelector);
        this.yearSelector = new JComboBox(this.getYears(0));
        this.yearSelector.addActionListener(this);
        this.yearSelector.setActionCommand("yearSelectionChanged");
        jPanel.add(this.yearSelector);
        return jPanel;
    }

    private JPanel constructControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.todayButton = new JButton("Today");
        this.todayButton.addActionListener(this);
        this.todayButton.setActionCommand("todayButtonClicked");
        jPanel.add(this.todayButton);
        return jPanel;
    }
}

