/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.ui;

import ai.org.jfree.ui.Drawable;
import ai.org.jfree.ui.ExtendedDrawable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class DrawablePanel
extends JPanel {
    private Drawable drawable;

    public DrawablePanel() {
        this.setOpaque(false);
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.drawable instanceof ExtendedDrawable) {
            ExtendedDrawable extendedDrawable = (ExtendedDrawable)this.drawable;
            return extendedDrawable.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.drawable instanceof ExtendedDrawable) {
            ExtendedDrawable extendedDrawable = (ExtendedDrawable)this.drawable;
            return extendedDrawable.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    public boolean isOpaque() {
        if (this.drawable == null) {
            return false;
        }
        return super.isOpaque();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawable == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.getWidth(), this.getHeight());
        this.drawable.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        graphics2D.dispose();
    }
}

