/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.xy;

import ai.org.jfree.data.general.Series;
import ai.org.jfree.data.general.SeriesException;
import ai.org.jfree.data.xy.XYDataItem;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XYSeries
extends Series
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5908509288197150436L;
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public XYSeries(Comparable comparable) {
        this(comparable, true, true);
    }

    public XYSeries(Comparable comparable, boolean bl) {
        this(comparable, bl, true);
    }

    public XYSeries(Comparable comparable, boolean bl, boolean bl2) {
        super(comparable);
        this.data = new ArrayList();
        this.autoSort = bl;
        this.allowDuplicateXValues = bl2;
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    private void updateBoundsForAddedItem(XYDataItem xYDataItem) {
        double d = xYDataItem.getXValue();
        this.minX = this.minIgnoreNaN(this.minX, d);
        this.maxX = this.maxIgnoreNaN(this.maxX, d);
        if (xYDataItem.getY() != null) {
            double d2 = xYDataItem.getYValue();
            this.minY = this.minIgnoreNaN(this.minY, d2);
            this.maxY = this.maxIgnoreNaN(this.maxY, d2);
        }
    }

    private void updateBoundsForRemovedItem(XYDataItem xYDataItem) {
        double d;
        boolean bl = false;
        boolean bl2 = false;
        double d2 = xYDataItem.getXValue();
        if (!Double.isNaN(d2) && (d2 <= this.minX || d2 >= this.maxX)) {
            bl = true;
        }
        if (xYDataItem.getY() != null && !Double.isNaN(d = xYDataItem.getYValue()) && (d <= this.minY || d >= this.maxY)) {
            bl2 = true;
        }
        if (bl2) {
            this.findBoundsByIteration();
        } else if (bl) {
            if (this.getAutoSort()) {
                this.minX = this.getX(0).doubleValue();
                this.maxX = this.getX(this.getItemCount() - 1).doubleValue();
            } else {
                this.findBoundsByIteration();
            }
        }
    }

    private void findBoundsByIteration() {
        this.minX = Double.NaN;
        this.maxX = Double.NaN;
        this.minY = Double.NaN;
        this.maxY = Double.NaN;
        for (XYDataItem xYDataItem : this.data) {
            this.updateBoundsForAddedItem(xYDataItem);
        }
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
        int n2 = this.data.size() - n;
        if (n2 > 0) {
            this.data.subList(0, n2).clear();
            this.findBoundsByIteration();
            this.fireSeriesChanged();
        }
    }

    public void add(XYDataItem xYDataItem) {
        this.add(xYDataItem, true);
    }

    public void add(double d, double d2) {
        this.add(new Double(d), (Number)new Double(d2), true);
    }

    public void add(double d, double d2, boolean bl) {
        this.add(new Double(d), (Number)new Double(d2), bl);
    }

    public void add(double d, Number number) {
        this.add(new Double(d), number);
    }

    public void add(double d, Number number, boolean bl) {
        this.add(new Double(d), number, bl);
    }

    public void add(Number number, Number number2) {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XYDataItem xYDataItem, boolean bl) {
        int n;
        if (xYDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        xYDataItem = (XYDataItem)xYDataItem.clone();
        if (this.autoSort) {
            n = Collections.binarySearch(this.data, xYDataItem);
            if (n < 0) {
                this.data.add(-n - 1, xYDataItem);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int n2 = this.data.size();
                while (n < n2 && xYDataItem.compareTo(this.data.get(n)) == 0) {
                    ++n;
                }
                if (n < this.data.size()) {
                    this.data.add(n, xYDataItem);
                } else {
                    this.data.add(xYDataItem);
                }
            }
        } else {
            if (!this.allowDuplicateXValues && (n = this.indexOf(xYDataItem.getX())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(xYDataItem);
        }
        this.updateBoundsForAddedItem(xYDataItem);
        if (this.getItemCount() > this.maximumItemCount) {
            XYDataItem xYDataItem2 = (XYDataItem)this.data.remove(0);
            this.updateBoundsForRemovedItem(xYDataItem2);
        }
        if (!bl) return;
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        this.data.subList(n, n2 + 1).clear();
        this.findBoundsByIteration();
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int n) {
        XYDataItem xYDataItem = (XYDataItem)this.data.remove(n);
        this.updateBoundsForRemovedItem(xYDataItem);
        this.fireSeriesChanged();
        return xYDataItem;
    }

    public XYDataItem remove(Number number) {
        return this.remove(this.indexOf(number));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.minX = Double.NaN;
            this.maxX = Double.NaN;
            this.minY = Double.NaN;
            this.maxY = Double.NaN;
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int n) {
        XYDataItem xYDataItem = (XYDataItem)this.data.get(n);
        return (XYDataItem)xYDataItem.clone();
    }

    XYDataItem getRawDataItem(int n) {
        return (XYDataItem)this.data.get(n);
    }

    public Number getX(int n) {
        return this.getRawDataItem(n).getX();
    }

    public Number getY(int n) {
        return this.getRawDataItem(n).getY();
    }

    public void update(int n, Number number) {
        XYDataItem xYDataItem = this.getRawDataItem(n);
        boolean bl = false;
        double d = xYDataItem.getYValue();
        if (!Double.isNaN(d)) {
            bl = d <= this.minY || d >= this.maxY;
        }
        xYDataItem.setY(number);
        if (bl) {
            this.findBoundsByIteration();
        } else if (number != null) {
            double d2 = number.doubleValue();
            this.minY = this.minIgnoreNaN(this.minY, d2);
            this.maxY = this.maxIgnoreNaN(this.maxY, d2);
        }
        this.fireSeriesChanged();
    }

    private double minIgnoreNaN(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.min(d, d2);
    }

    private double maxIgnoreNaN(double d, double d2) {
        if (Double.isNaN(d)) {
            return d2;
        }
        if (Double.isNaN(d2)) {
            return d;
        }
        return Math.max(d, d2);
    }

    public void updateByIndex(int n, Number number) {
        this.update(n, number);
    }

    public void update(Number number, Number number2) {
        int n = this.indexOf(number);
        if (n < 0) {
            throw new SeriesException("No observation for x = " + number);
        }
        this.updateByIndex(n, number2);
    }

    public XYDataItem addOrUpdate(double d, double d2) {
        return this.addOrUpdate(new Double(d), new Double(d2));
    }

    public XYDataItem addOrUpdate(Number number, Number number2) {
        return this.addOrUpdate(new XYDataItem(number, number2));
    }

    public XYDataItem addOrUpdate(XYDataItem xYDataItem) {
        if (xYDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        if (this.allowDuplicateXValues) {
            this.add(xYDataItem);
            return null;
        }
        XYDataItem xYDataItem2 = null;
        int n = this.indexOf(xYDataItem.getX());
        if (n >= 0) {
            XYDataItem xYDataItem3 = (XYDataItem)this.data.get(n);
            xYDataItem2 = (XYDataItem)xYDataItem3.clone();
            boolean bl = false;
            double d = xYDataItem3.getYValue();
            if (!Double.isNaN(d)) {
                bl = d <= this.minY || d >= this.maxY;
            }
            xYDataItem3.setY(xYDataItem.getY());
            if (bl) {
                this.findBoundsByIteration();
            } else if (xYDataItem.getY() != null) {
                double d2 = xYDataItem.getY().doubleValue();
                this.minY = this.minIgnoreNaN(this.minY, d2);
                this.maxY = this.minIgnoreNaN(this.maxY, d2);
            }
        } else {
            xYDataItem = (XYDataItem)xYDataItem.clone();
            if (this.autoSort) {
                this.data.add(-n - 1, xYDataItem);
            } else {
                this.data.add(xYDataItem);
            }
            this.updateBoundsForAddedItem(xYDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                XYDataItem xYDataItem4 = (XYDataItem)this.data.remove(0);
                this.updateBoundsForRemovedItem(xYDataItem4);
            }
        }
        this.fireSeriesChanged();
        return xYDataItem2;
    }

    public int indexOf(Number number) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new XYDataItem(number, null));
        }
        for (int i = 0; i < this.data.size(); ++i) {
            XYDataItem xYDataItem = (XYDataItem)this.data.get(i);
            if (!xYDataItem.getX().equals(number)) continue;
            return i;
        }
        return -1;
    }

    public double[][] toArray() {
        int n = this.getItemCount();
        double[][] dArray = new double[2][n];
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = this.getX(i).doubleValue();
            Number number = this.getY(i);
            dArray[1][i] = number != null ? number.doubleValue() : Double.NaN;
        }
        return dArray;
    }

    public Object clone() throws CloneNotSupportedException {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = (List)ObjectUtilities.deepClone(this.data);
        return xYSeries;
    }

    public XYSeries createCopy(int n, int n2) throws CloneNotSupportedException {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                XYDataItem xYDataItem = (XYDataItem)this.data.get(i);
                XYDataItem xYDataItem2 = (XYDataItem)xYDataItem.clone();
                try {
                    xYSeries.add(xYDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("Unable to add cloned data item.");
                }
            }
        }
        return xYSeries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYSeries xYSeries = (XYSeries)object;
        if (this.maximumItemCount != xYSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != xYSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != xYSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeries.data);
    }

    public int hashCode() {
        XYDataItem xYDataItem;
        int n = super.hashCode();
        int n2 = this.getItemCount();
        if (n2 > 0) {
            xYDataItem = this.getRawDataItem(0);
            n = 29 * n + xYDataItem.hashCode();
        }
        if (n2 > 1) {
            xYDataItem = this.getRawDataItem(n2 - 1);
            n = 29 * n + xYDataItem.hashCode();
        }
        if (n2 > 2) {
            xYDataItem = this.getRawDataItem(n2 / 2);
            n = 29 * n + xYDataItem.hashCode();
        }
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + (this.autoSort ? 1 : 0);
        n = 29 * n + (this.allowDuplicateXValues ? 1 : 0);
        return n;
    }
}

