/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time.ohlc;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriodAnchor;
import ai.org.jfree.data.time.ohlc.OHLCItem;
import ai.org.jfree.data.time.ohlc.OHLCSeries;
import ai.org.jfree.data.xy.AbstractXYDataset;
import ai.org.jfree.data.xy.OHLCDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OHLCSeriesCollection
extends AbstractXYDataset
implements OHLCDataset,
Serializable {
    private List data;
    private TimePeriodAnchor xPosition = TimePeriodAnchor.MIDDLE;

    public OHLCSeriesCollection() {
        this.data = new ArrayList();
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        if (timePeriodAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.xPosition = timePeriodAnchor;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(OHLCSeries oHLCSeries) {
        if (oHLCSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(oHLCSeries);
        oHLCSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public OHLCSeries getSeries(int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (OHLCSeries)this.data.get(n);
    }

    public Comparable getSeriesKey(int n) {
        return this.getSeries(n).getKey();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    protected synchronized long getX(RegularTimePeriod regularTimePeriod) {
        long l = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l = regularTimePeriod.getFirstMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l = regularTimePeriod.getMiddleMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l = regularTimePeriod.getLastMillisecond();
        }
        return l;
    }

    public double getXValue(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        RegularTimePeriod regularTimePeriod = oHLCItem.getPeriod();
        return this.getX(regularTimePeriod);
    }

    public Number getX(int n, int n2) {
        return new Double(this.getXValue(n, n2));
    }

    public Number getY(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        return new Double(oHLCItem.getYValue());
    }

    public double getOpenValue(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        return oHLCItem.getOpenValue();
    }

    public Number getOpen(int n, int n2) {
        return new Double(this.getOpenValue(n, n2));
    }

    public double getCloseValue(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        return oHLCItem.getCloseValue();
    }

    public Number getClose(int n, int n2) {
        return new Double(this.getCloseValue(n, n2));
    }

    public double getHighValue(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        return oHLCItem.getHighValue();
    }

    public Number getHigh(int n, int n2) {
        return new Double(this.getHighValue(n, n2));
    }

    public double getLowValue(int n, int n2) {
        OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(n);
        OHLCItem oHLCItem = (OHLCItem)oHLCSeries.getDataItem(n2);
        return oHLCItem.getLowValue();
    }

    public Number getLow(int n, int n2) {
        return new Double(this.getLowValue(n, n2));
    }

    public Number getVolume(int n, int n2) {
        return null;
    }

    public double getVolumeValue(int n, int n2) {
        return Double.NaN;
    }

    public void removeSeries(int n) {
        OHLCSeries oHLCSeries = this.getSeries(n);
        if (oHLCSeries != null) {
            this.removeSeries(oHLCSeries);
        }
    }

    public boolean removeSeries(OHLCSeries oHLCSeries) {
        if (oHLCSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        boolean bl = this.data.remove(oHLCSeries);
        if (bl) {
            oHLCSeries.removeChangeListener(this);
            this.fireDatasetChanged();
        }
        return bl;
    }

    public void removeAllSeries() {
        if (this.data.size() == 0) {
            return;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            OHLCSeries oHLCSeries = (OHLCSeries)this.data.get(i);
            oHLCSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OHLCSeriesCollection)) {
            return false;
        }
        OHLCSeriesCollection oHLCSeriesCollection = (OHLCSeriesCollection)object;
        if (!this.xPosition.equals(oHLCSeriesCollection.xPosition)) {
            return false;
        }
        return ObjectUtilities.equal(this.data, oHLCSeriesCollection.data);
    }

    public int hashCode() {
        int n = 137;
        n = HashUtilities.hashCode(n, this.xPosition);
        for (int i = 0; i < this.data.size(); ++i) {
            n = HashUtilities.hashCode(n, this.data.get(i));
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        OHLCSeriesCollection oHLCSeriesCollection = (OHLCSeriesCollection)super.clone();
        oHLCSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        return oHLCSeriesCollection;
    }
}

