/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriodFormatException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Year
extends RegularTimePeriod
implements Serializable {
    public static final int MINIMUM_YEAR = -9999;
    public static final int MAXIMUM_YEAR = 9999;
    private static final long serialVersionUID = -7659990929736074836L;
    private short year;
    private long firstMillisecond;
    private long lastMillisecond;

    public Year() {
        this(new Date());
    }

    public Year(int n) {
        if (n < -9999 || n > 9999) {
            throw new IllegalArgumentException("Year constructor: year (" + n + ") outside valid range.");
        }
        this.year = (short)n;
        this.peg(Calendar.getInstance());
    }

    public Year(Date date) {
        this(date, TimeZone.getDefault());
    }

    public Year(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Year(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        this.year = (short)calendar.get(1);
        this.peg(calendar);
    }

    public int getYear() {
        return this.year;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        if (this.year > -9999) {
            return new Year(this.year - 1);
        }
        return null;
    }

    public RegularTimePeriod next() {
        if (this.year < 9999) {
            return new Year(this.year + 1);
        }
        return null;
    }

    public long getSerialIndex() {
        return this.year;
    }

    public long getFirstMillisecond(Calendar calendar) {
        calendar.set(this.year, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        calendar.set(this.year, 11, 31, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Year)) {
            return false;
        }
        Year year = (Year)object;
        return this.year == year.year;
    }

    public int hashCode() {
        int n = 17;
        short s = this.year;
        n = 37 * n + s;
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Year) {
            Year year = (Year)object;
            n = this.year - year.getYear();
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return Integer.toString(this.year);
    }

    public static Year parseYear(String string) {
        int n;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimePeriodFormatException("Cannot parse string.");
        }
        try {
            return new Year(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TimePeriodFormatException("Year outside valid range.");
        }
    }
}

