/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.time;

import ai.org.jfree.data.time.RegularTimePeriod;
import ai.org.jfree.data.time.TimePeriodFormatException;
import ai.org.jfree.data.time.Year;
import ai.org.jfree.date.SerialDate;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Quarter
extends RegularTimePeriod
implements Serializable {
    private static final long serialVersionUID = 3810061714380888671L;
    public static final int FIRST_QUARTER = 1;
    public static final int LAST_QUARTER = 4;
    public static final int[] FIRST_MONTH_IN_QUARTER = new int[]{0, 1, 4, 7, 10};
    public static final int[] LAST_MONTH_IN_QUARTER = new int[]{0, 3, 6, 9, 12};
    private short year;
    private byte quarter;
    private long firstMillisecond;
    private long lastMillisecond;

    public Quarter() {
        this(new Date());
    }

    public Quarter(int n, int n2) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Quarter outside valid range.");
        }
        this.year = (short)n2;
        this.quarter = (byte)n;
        this.peg(Calendar.getInstance());
    }

    public Quarter(int n, Year year) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Quarter outside valid range.");
        }
        this.year = (short)year.getYear();
        this.quarter = (byte)n;
        this.peg(Calendar.getInstance());
    }

    public Quarter(Date date) {
        this(date, TimeZone.getDefault());
    }

    public Quarter(Date date, TimeZone timeZone) {
        this(date, timeZone, Locale.getDefault());
    }

    public Quarter(Date date, TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        this.quarter = (byte)SerialDate.monthCodeToQuarter(n);
        this.year = (short)calendar.get(1);
        this.peg(calendar);
    }

    public int getQuarter() {
        return this.quarter;
    }

    public Year getYear() {
        return new Year(this.year);
    }

    public int getYearValue() {
        return this.year;
    }

    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    public void peg(Calendar calendar) {
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    public RegularTimePeriod previous() {
        Quarter quarter = this.quarter > 1 ? new Quarter(this.quarter - 1, this.year) : (this.year > 1900 ? new Quarter(4, this.year - 1) : null);
        return quarter;
    }

    public RegularTimePeriod next() {
        Quarter quarter = this.quarter < 4 ? new Quarter(this.quarter + 1, this.year) : (this.year < 9999 ? new Quarter(1, this.year + 1) : null);
        return quarter;
    }

    public long getSerialIndex() {
        return (long)this.year * 4L + (long)this.quarter;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Quarter) {
                Quarter quarter = (Quarter)object;
                return this.quarter == quarter.getQuarter() && this.year == quarter.getYearValue();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.quarter;
        n = 37 * n + this.year;
        return n;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Quarter) {
            Quarter quarter = (Quarter)object;
            n = this.year - quarter.getYearValue();
            if (n == 0) {
                n = this.quarter - quarter.getQuarter();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return "Q" + this.quarter + "/" + this.year;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = FIRST_MONTH_IN_QUARTER[this.quarter];
        calendar.set(this.year, n - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = LAST_MONTH_IN_QUARTER[this.quarter];
        int n2 = SerialDate.lastDayOfMonth(n, this.year);
        calendar.set(this.year, n - 1, n2, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Quarter parseQuarter(String string) {
        int n = string.indexOf("Q");
        if (n == -1) {
            throw new TimePeriodFormatException("Missing Q.");
        }
        if (n == string.length() - 1) {
            throw new TimePeriodFormatException("Q found at end of string.");
        }
        String string2 = string.substring(n + 1, n + 2);
        int n2 = Integer.parseInt(string2);
        String string3 = string.substring(0, n) + string.substring(n + 2, string.length());
        string3 = string3.replace('/', ' ');
        string3 = string3.replace(',', ' ');
        string3 = string3.replace('-', ' ');
        Year year = Year.parseYear(string3.trim());
        Quarter quarter = new Quarter(n2, year);
        return quarter;
    }
}

