/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.statistics;

import ai.org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] dArray) {
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = dArray[i][0];
            double d6 = dArray[i][1];
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
        }
        double d9 = d3 - d * d / (double)n;
        double d10 = d4 - d * d2 / (double)n;
        double d11 = d / (double)n;
        double d12 = d2 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d10 / d9;
        dArray2[0] = d12 - dArray2[1] * d11;
        return dArray2;
    }

    public static double[] getOLSRegression(XYDataset xYDataset, int n) {
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d5 = xYDataset.getXValue(n, i);
            double d6 = xYDataset.getYValue(n, i);
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
        }
        double d9 = d3 - d * d / (double)n2;
        double d10 = d4 - d * d2 / (double)n2;
        double d11 = d / (double)n2;
        double d12 = d2 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d10 / d9;
        dArray[0] = d12 - dArray[1] * d11;
        return dArray;
    }

    public static double[] getPowerRegression(double[][] dArray) {
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = Math.log(dArray[i][0]);
            double d6 = Math.log(dArray[i][1]);
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
        }
        double d9 = d3 - d * d / (double)n;
        double d10 = d4 - d * d2 / (double)n;
        double d11 = d / (double)n;
        double d12 = d2 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d10 / d9;
        dArray2[0] = Math.pow(Math.exp(1.0), d12 - dArray2[1] * d11);
        return dArray2;
    }

    public static double[] getPowerRegression(XYDataset xYDataset, int n) {
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d5 = Math.log(xYDataset.getXValue(n, i));
            double d6 = Math.log(xYDataset.getYValue(n, i));
            d += d5;
            d2 += d6;
            double d7 = d5 * d5;
            d3 += d7;
            double d8 = d5 * d6;
            d4 += d8;
        }
        double d9 = d3 - d * d / (double)n2;
        double d10 = d4 - d * d2 / (double)n2;
        double d11 = d / (double)n2;
        double d12 = d2 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d10 / d9;
        dArray[0] = Math.pow(Math.exp(1.0), d12 - dArray[1] * d11);
        return dArray;
    }

    public static double[] getPolynomialRegression(XYDataset xYDataset, int n, int n2) {
        double d;
        int n3;
        int n4;
        int n5;
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        int n6 = xYDataset.getItemCount(n);
        if (n6 < n2 + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int n7 = 0;
        double[][] dArray = new double[2][n6];
        for (n5 = 0; n5 < n6; ++n5) {
            double d2 = xYDataset.getXValue(n, n5);
            double d3 = xYDataset.getYValue(n, n5);
            if (Double.isNaN(d2) || Double.isNaN(d3)) continue;
            dArray[0][n7] = d2;
            dArray[1][n7] = d3;
            ++n7;
        }
        if (n7 < n2 + 1) {
            throw new IllegalArgumentException("Not enough data.");
        }
        n5 = n2 + 1;
        int n8 = n2 + 2;
        double[] dArray2 = new double[n5 + 1];
        double[][] dArray3 = new double[n5][n8];
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < n7; ++i) {
            d4 += dArray[0][i];
            d5 += dArray[1][i];
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n8 - 1; ++n3) {
                    double[] dArray4 = dArray3[n4];
                    int n9 = n3;
                    dArray4[n9] = dArray4[n9] + Math.pow(dArray[0][i], n4 + n3);
                }
                double[] dArray5 = dArray3[n4];
                int n10 = n8 - 1;
                dArray5[n10] = dArray5[n10] + dArray[1][i] * Math.pow(dArray[0][i], n4);
            }
        }
        double[][] dArray6 = Regression.calculateSubMatrix(dArray3);
        for (n4 = 1; n4 < n5; ++n4) {
            dArray3[n4][0] = 0.0;
            for (n3 = 1; n3 < n8; ++n3) {
                dArray3[n4][n3] = dArray6[n4 - 1][n3 - 1];
            }
        }
        for (n4 = n5 - 1; n4 > -1; --n4) {
            double d6 = dArray3[n4][n8 - 1];
            for (int i = n4; i < n8 - 1; ++i) {
                d6 -= dArray3[n4][i] * dArray2[i];
            }
            dArray2[n4] = d6 / dArray3[n4][n4];
        }
        double d7 = d5 / (double)n7;
        double d8 = 0.0;
        double d9 = 0.0;
        for (int i = 0; i < n7; ++i) {
            double d10 = 0.0;
            for (int j = 0; j < n5; ++j) {
                d10 += dArray2[j] * Math.pow(dArray[0][i], j);
            }
            d9 += Math.pow(d10 - d7, 2.0);
            d8 += Math.pow(dArray[1][i] - d7, 2.0);
        }
        dArray2[n5] = d = d9 / d8;
        return dArray2;
    }

    private static double[][] calculateSubMatrix(double[][] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3 - 1][n4 - 1];
        for (n2 = 1; n2 < n3; ++n2) {
            double d = dArray[0][0] / dArray[n2][0];
            for (n = 1; n < n4; ++n) {
                dArray2[n2 - 1][n - 1] = dArray[0][n] - dArray[n2][n] * d;
            }
        }
        if (n3 == 1) {
            return dArray2;
        }
        if (dArray2[0][0] == 0.0) {
            n2 = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (dArray2[i][0] == 0.0) continue;
                n2 = 1;
                double[] dArray3 = dArray2[0];
                for (n = 0; n < dArray2[i].length; ++n) {
                    dArray2[0][n] = dArray2[i][n];
                }
                for (n = 0; n < dArray3.length; ++n) {
                    dArray2[i][n] = dArray3[n];
                }
                break;
            }
            if (n2 == 0) {
                System.out.println("Equation has no solution!");
                return new double[n3 - 1][n4 - 1];
            }
        }
        double[][] dArray4 = Regression.calculateSubMatrix(dArray2);
        for (int i = 1; i < n3 - 1; ++i) {
            dArray2[i][0] = 0.0;
            for (int j = 1; j < n4 - 1; ++j) {
                dArray2[i][j] = dArray4[i - 1][j - 1];
            }
        }
        return dArray2;
    }
}

