/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.statistics;

import ai.org.jfree.data.KeyedObjects2D;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.RangeInfo;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.statistics.MeanAndStandardDeviation;
import ai.org.jfree.data.statistics.StatisticalCategoryDataset;
import ai.org.jfree.util.PublicCloneable;
import java.util.List;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo,
PublicCloneable {
    private KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private int minimumRangeValueRow = -1;
    private int minimumRangeValueColumn = -1;
    private double minimumRangeValueIncStdDev;
    private int minimumRangeValueIncStdDevRow = -1;
    private int minimumRangeValueIncStdDevColumn = -1;
    private double maximumRangeValue = Double.NaN;
    private int maximumRangeValueRow = -1;
    private int maximumRangeValueColumn = -1;
    private double maximumRangeValueIncStdDev;
    private int maximumRangeValueIncStdDevRow = -1;
    private int maximumRangeValueIncStdDevColumn = -1;

    public DefaultStatisticalCategoryDataset() {
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDev = Double.NaN;
    }

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getValue(int n, int n2) {
        return this.getMeanValue(n, n2);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(comparable, comparable2);
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getStdDevValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public Number getStdDevValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double d, double d2, Comparable comparable, Comparable comparable2) {
        this.add(new Double(d), new Double(d2), comparable, comparable2);
    }

    public void add(Number number, Number number2, Comparable comparable, Comparable comparable2) {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(number, number2);
        this.data.addObject(meanAndStandardDeviation, comparable, comparable2);
        double d = Double.NaN;
        double d2 = Double.NaN;
        if (number != null) {
            d = number.doubleValue();
        }
        if (number2 != null) {
            d2 = number2.doubleValue();
        }
        int n = this.data.getColumnIndex(comparable2);
        int n2 = this.data.getRowIndex(comparable);
        if (n == this.maximumRangeValueRow && n2 == this.maximumRangeValueColumn || n == this.maximumRangeValueIncStdDevRow && n2 == this.maximumRangeValueIncStdDevColumn || n == this.minimumRangeValueRow && n2 == this.minimumRangeValueColumn || n == this.minimumRangeValueIncStdDevRow && n2 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        } else {
            if (!Double.isNaN(d) && (Double.isNaN(this.maximumRangeValue) || d > this.maximumRangeValue)) {
                this.maximumRangeValue = d;
                this.maximumRangeValueRow = n;
                this.maximumRangeValueColumn = n2;
            }
            if (!Double.isNaN(d + d2) && (Double.isNaN(this.maximumRangeValueIncStdDev) || d + d2 > this.maximumRangeValueIncStdDev)) {
                this.maximumRangeValueIncStdDev = d + d2;
                this.maximumRangeValueIncStdDevRow = n;
                this.maximumRangeValueIncStdDevColumn = n2;
            }
            if (!Double.isNaN(d) && (Double.isNaN(this.minimumRangeValue) || d < this.minimumRangeValue)) {
                this.minimumRangeValue = d;
                this.minimumRangeValueRow = n;
                this.minimumRangeValueColumn = n2;
            }
            if (!Double.isNaN(d - d2) && (Double.isNaN(this.minimumRangeValueIncStdDev) || d - d2 < this.minimumRangeValueIncStdDev)) {
                this.minimumRangeValueIncStdDev = d - d2;
                this.minimumRangeValueIncStdDevRow = n;
                this.minimumRangeValueIncStdDevColumn = n2;
            }
        }
        this.fireDatasetChanged();
    }

    public void remove(Comparable comparable, Comparable comparable2) {
        int n = this.getRowIndex(comparable);
        int n2 = this.getColumnIndex(comparable2);
        this.data.removeObject(comparable, comparable2);
        if (n == this.maximumRangeValueRow && n2 == this.maximumRangeValueColumn || n == this.maximumRangeValueIncStdDevRow && n2 == this.maximumRangeValueIncStdDevColumn || n == this.minimumRangeValueRow && n2 == this.minimumRangeValueColumn || n == this.minimumRangeValueIncStdDevRow && n2 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        }
        this.fireDatasetChanged();
    }

    public void removeRow(int n) {
        this.data.removeRow(n);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable comparable) {
        this.data.removeRow(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(int n) {
        this.data.removeColumn(n);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable comparable) {
        this.data.removeColumn(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.updateBounds();
        this.fireDatasetChanged();
    }

    private void updateBounds() {
        this.maximumRangeValue = Double.NaN;
        this.maximumRangeValueRow = -1;
        this.maximumRangeValueColumn = -1;
        this.minimumRangeValue = Double.NaN;
        this.minimumRangeValueRow = -1;
        this.minimumRangeValueColumn = -1;
        this.maximumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDevRow = -1;
        this.maximumRangeValueIncStdDevColumn = -1;
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.minimumRangeValueIncStdDevRow = -1;
        this.minimumRangeValueIncStdDevColumn = -1;
        int n = this.data.getRowCount();
        int n2 = this.data.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(i, j);
                if (meanAndStandardDeviation == null) continue;
                double d = meanAndStandardDeviation.getMeanValue();
                double d2 = meanAndStandardDeviation.getStandardDeviationValue();
                if (Double.isNaN(d)) continue;
                if (Double.isNaN(this.maximumRangeValue)) {
                    this.maximumRangeValue = d;
                    this.maximumRangeValueRow = i;
                    this.maximumRangeValueColumn = j;
                } else if (d > this.maximumRangeValue) {
                    this.maximumRangeValue = d;
                    this.maximumRangeValueRow = i;
                    this.maximumRangeValueColumn = j;
                }
                if (Double.isNaN(this.minimumRangeValue)) {
                    this.minimumRangeValue = d;
                    this.minimumRangeValueRow = i;
                    this.minimumRangeValueColumn = j;
                } else if (d < this.minimumRangeValue) {
                    this.minimumRangeValue = d;
                    this.minimumRangeValueRow = i;
                    this.minimumRangeValueColumn = j;
                }
                if (Double.isNaN(d2)) continue;
                if (Double.isNaN(this.maximumRangeValueIncStdDev)) {
                    this.maximumRangeValueIncStdDev = d + d2;
                    this.maximumRangeValueIncStdDevRow = i;
                    this.maximumRangeValueIncStdDevColumn = j;
                } else if (d + d2 > this.maximumRangeValueIncStdDev) {
                    this.maximumRangeValueIncStdDev = d + d2;
                    this.maximumRangeValueIncStdDevRow = i;
                    this.maximumRangeValueIncStdDevColumn = j;
                }
                if (Double.isNaN(this.minimumRangeValueIncStdDev)) {
                    this.minimumRangeValueIncStdDev = d - d2;
                    this.minimumRangeValueIncStdDevRow = i;
                    this.minimumRangeValueIncStdDevColumn = j;
                    continue;
                }
                if (!(d - d2 < this.minimumRangeValueIncStdDev)) continue;
                this.minimumRangeValueIncStdDev = d - d2;
                this.minimumRangeValueIncStdDevRow = i;
                this.minimumRangeValueIncStdDevColumn = j;
            }
        }
    }

    public double getRangeLowerBound(boolean bl) {
        if (bl && !Double.isNaN(this.minimumRangeValueIncStdDev)) {
            return this.minimumRangeValueIncStdDev;
        }
        return this.minimumRangeValue;
    }

    public double getRangeUpperBound(boolean bl) {
        if (bl && !Double.isNaN(this.maximumRangeValueIncStdDev)) {
            return this.maximumRangeValueIncStdDev;
        }
        return this.maximumRangeValue;
    }

    public Range getRangeBounds(boolean bl) {
        double d = this.getRangeLowerBound(bl);
        double d2 = this.getRangeUpperBound(bl);
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return null;
        }
        return new Range(d, d2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultStatisticalCategoryDataset)) {
            return false;
        }
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = (DefaultStatisticalCategoryDataset)object;
        return this.data.equals(defaultStatisticalCategoryDataset.data);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = (DefaultStatisticalCategoryDataset)super.clone();
        defaultStatisticalCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultStatisticalCategoryDataset;
    }
}

