/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.general;

import ai.org.jfree.chart.renderer.PaintScale;
import ai.org.jfree.data.general.HeatMapDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYSeries;
import ai.org.jfree.data.xy.XYSeriesCollection;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;

public abstract class HeatMapUtilities {
    public static XYDataset extractRowFromHeatMapDataset(HeatMapDataset heatMapDataset, int n, Comparable comparable) {
        XYSeries xYSeries = new XYSeries(comparable);
        int n2 = heatMapDataset.getXSampleCount();
        for (int i = 0; i < n2; ++i) {
            xYSeries.add(heatMapDataset.getXValue(i), heatMapDataset.getZValue(i, n));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static XYDataset extractColumnFromHeatMapDataset(HeatMapDataset heatMapDataset, int n, Comparable comparable) {
        XYSeries xYSeries = new XYSeries(comparable);
        int n2 = heatMapDataset.getYSampleCount();
        for (int i = 0; i < n2; ++i) {
            xYSeries.add(heatMapDataset.getYValue(i), heatMapDataset.getZValue(n, i));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static BufferedImage createHeatMapImage(HeatMapDataset heatMapDataset, PaintScale paintScale) {
        if (heatMapDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (paintScale == null) {
            throw new IllegalArgumentException("Null 'paintScale' argument.");
        }
        int n = heatMapDataset.getXSampleCount();
        int n2 = heatMapDataset.getYSampleCount();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = heatMapDataset.getZValue(i, j);
                Paint paint = paintScale.getPaint(d);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(i, n2 - j - 1, 1, 1);
            }
        }
        return bufferedImage;
    }
}

