/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.general;

import ai.org.jfree.data.DataUtilities;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.general.HeatMapDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;

public class DefaultHeatMapDataset
extends AbstractDataset
implements HeatMapDataset,
Cloneable,
PublicCloneable,
Serializable {
    private int xSamples;
    private int ySamples;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double[][] zValues;

    public DefaultHeatMapDataset(int n, int n2, double d, double d2, double d3, double d4) {
        if (n < 1) {
            throw new IllegalArgumentException("Requires 'xSamples' > 0");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Requires 'ySamples' > 0");
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("'minX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("'maxX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("'minY' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d4) || Double.isNaN(d4)) {
            throw new IllegalArgumentException("'maxY' cannot be INF or NaN.");
        }
        this.xSamples = n;
        this.ySamples = n2;
        this.minX = d;
        this.maxX = d2;
        this.minY = d3;
        this.maxY = d4;
        this.zValues = new double[n][];
        for (int i = 0; i < n; ++i) {
            this.zValues[i] = new double[n2];
        }
    }

    public int getXSampleCount() {
        return this.xSamples;
    }

    public int getYSampleCount() {
        return this.ySamples;
    }

    public double getMinimumXValue() {
        return this.minX;
    }

    public double getMaximumXValue() {
        return this.maxX;
    }

    public double getMinimumYValue() {
        return this.minY;
    }

    public double getMaximumYValue() {
        return this.maxY;
    }

    public double getXValue(int n) {
        double d = this.minX + (this.maxX - this.minX) * ((double)n / (double)this.xSamples);
        return d;
    }

    public double getYValue(int n) {
        double d = this.minY + (this.maxY - this.minY) * ((double)n / (double)this.ySamples);
        return d;
    }

    public double getZValue(int n, int n2) {
        return this.zValues[n][n2];
    }

    public Number getZ(int n, int n2) {
        return new Double(this.getZValue(n, n2));
    }

    public void setZValue(int n, int n2, double d) {
        this.setZValue(n, n2, d, true);
    }

    public void setZValue(int n, int n2, double d, boolean bl) {
        this.zValues[n][n2] = d;
        if (bl) {
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultHeatMapDataset)) {
            return false;
        }
        DefaultHeatMapDataset defaultHeatMapDataset = (DefaultHeatMapDataset)object;
        if (this.xSamples != defaultHeatMapDataset.xSamples) {
            return false;
        }
        if (this.ySamples != defaultHeatMapDataset.ySamples) {
            return false;
        }
        if (this.minX != defaultHeatMapDataset.minX) {
            return false;
        }
        if (this.maxX != defaultHeatMapDataset.maxX) {
            return false;
        }
        if (this.minY != defaultHeatMapDataset.minY) {
            return false;
        }
        if (this.maxY != defaultHeatMapDataset.maxY) {
            return false;
        }
        return DataUtilities.equal(this.zValues, defaultHeatMapDataset.zValues);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultHeatMapDataset defaultHeatMapDataset = (DefaultHeatMapDataset)super.clone();
        defaultHeatMapDataset.zValues = DataUtilities.clone(this.zValues);
        return defaultHeatMapDataset;
    }
}

