/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.gantt;

import ai.org.jfree.data.time.SimpleTimePeriod;
import ai.org.jfree.data.time.TimePeriod;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Task
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1094303785346988894L;
    private String description;
    private TimePeriod duration;
    private Double percentComplete;
    private List subtasks;

    public Task(String string, TimePeriod timePeriod) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'description' argument.");
        }
        this.description = string;
        this.duration = timePeriod;
        this.percentComplete = null;
        this.subtasks = new ArrayList();
    }

    public Task(String string, Date date, Date date2) {
        this(string, new SimpleTimePeriod(date, date2));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'description' argument.");
        }
        this.description = string;
    }

    public TimePeriod getDuration() {
        return this.duration;
    }

    public void setDuration(TimePeriod timePeriod) {
        this.duration = timePeriod;
    }

    public Double getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Double d) {
        this.percentComplete = d;
    }

    public void setPercentComplete(double d) {
        this.setPercentComplete(new Double(d));
    }

    public void addSubtask(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Null 'subtask' argument.");
        }
        this.subtasks.add(task);
    }

    public void removeSubtask(Task task) {
        this.subtasks.remove(task);
    }

    public int getSubtaskCount() {
        return this.subtasks.size();
    }

    public Task getSubtask(int n) {
        return (Task)this.subtasks.get(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Task)) {
            return false;
        }
        Task task = (Task)object;
        if (!ObjectUtilities.equal(this.description, task.description)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.duration, task.duration)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.percentComplete, task.percentComplete)) {
            return false;
        }
        return ObjectUtilities.equal(this.subtasks, task.subtasks);
    }

    public Object clone() throws CloneNotSupportedException {
        Task task = (Task)super.clone();
        return task;
    }
}

