/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.function;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.data.function.Function2D;
import java.io.Serializable;
import java.util.Arrays;

public class PolynomialFunction2D
implements Function2D,
Serializable {
    private double[] coefficients;

    public PolynomialFunction2D(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'coefficients' argument");
        }
        this.coefficients = (double[])dArray.clone();
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public int getOrder() {
        return this.coefficients.length - 1;
    }

    public double getValue(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            d2 += this.coefficients[i] * Math.pow(d, i);
        }
        return d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolynomialFunction2D)) {
            return false;
        }
        PolynomialFunction2D polynomialFunction2D = (PolynomialFunction2D)object;
        return Arrays.equals(this.coefficients, polynomialFunction2D.coefficients);
    }

    public int hashCode() {
        return HashUtilities.hashCodeForDoubleArray(this.coefficients);
    }
}

