/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.function;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.data.function.Function2D;
import java.io.Serializable;

public class NormalDistributionFunction2D
implements Function2D,
Serializable {
    private double mean;
    private double std;
    private double factor;
    private double denominator;

    public NormalDistributionFunction2D(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Requires 'std' > 0.");
        }
        this.mean = d;
        this.std = d2;
        this.factor = 1.0 / (d2 * Math.sqrt(Math.PI * 2));
        this.denominator = 2.0 * d2 * d2;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.std;
    }

    public double getValue(double d) {
        double d2 = d - this.mean;
        return this.factor * Math.exp(-d2 * d2 / this.denominator);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NormalDistributionFunction2D)) {
            return false;
        }
        NormalDistributionFunction2D normalDistributionFunction2D = (NormalDistributionFunction2D)object;
        if (this.mean != normalDistributionFunction2D.mean) {
            return false;
        }
        return this.std == normalDistributionFunction2D.std;
    }

    public int hashCode() {
        int n = 29;
        n = HashUtilities.hashCode(n, this.mean);
        n = HashUtilities.hashCode(n, this.std);
        return n;
    }
}

