/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.category;

import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.data.DataUtilities;
import ai.org.jfree.data.UnknownKeyException;
import ai.org.jfree.data.category.IntervalCategoryDataset;
import ai.org.jfree.data.general.AbstractSeriesDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultIntervalCategoryDataset
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    private Comparable[] seriesKeys;
    private Comparable[] categoryKeys;
    private Number[][] startData;
    private Number[][] endData;

    public DefaultIntervalCategoryDataset(double[][] dArray, double[][] dArray2) {
        this(DataUtilities.createNumberArray2D(dArray), DataUtilities.createNumberArray2D(dArray2));
    }

    public DefaultIntervalCategoryDataset(Number[][] numberArray, Number[][] numberArray2) {
        this(null, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(String[] stringArray, Number[][] numberArray, Number[][] numberArray2) {
        this((Comparable[])stringArray, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(Comparable[] comparableArray, Comparable[] comparableArray2, Number[][] numberArray, Number[][] numberArray2) {
        this.startData = numberArray;
        this.endData = numberArray2;
        if (numberArray != null && numberArray2 != null) {
            String string = "ai.org.jfree.data.resources.DataPackageResources";
            ResourceBundle resourceBundle = ResourceBundleWrapper.getBundle(string);
            int n = numberArray.length;
            if (n != numberArray2.length) {
                String string2 = "DefaultIntervalCategoryDataset: the number of series in the start value dataset does not match the number of series in the end value dataset.";
                throw new IllegalArgumentException(string2);
            }
            if (n > 0) {
                if (comparableArray != null) {
                    if (comparableArray.length != n) {
                        throw new IllegalArgumentException("The number of series keys does not match the number of series in the data.");
                    }
                    this.seriesKeys = comparableArray;
                } else {
                    String string3 = resourceBundle.getString("series.default-prefix") + " ";
                    this.seriesKeys = this.generateKeys(n, string3);
                }
                int n2 = numberArray[0].length;
                if (n2 != numberArray2[0].length) {
                    String string4 = "DefaultIntervalCategoryDataset: the number of categories in the start value dataset does not match the number of categories in the end value dataset.";
                    throw new IllegalArgumentException(string4);
                }
                if (comparableArray2 != null) {
                    if (comparableArray2.length != n2) {
                        throw new IllegalArgumentException("The number of category keys does not match the number of categories in the data.");
                    }
                    this.categoryKeys = comparableArray2;
                } else {
                    String string5 = resourceBundle.getString("categories.default-prefix") + " ";
                    this.categoryKeys = this.generateKeys(n2, string5);
                }
            } else {
                this.seriesKeys = new Comparable[0];
                this.categoryKeys = new Comparable[0];
            }
        }
    }

    public int getSeriesCount() {
        int n = 0;
        if (this.startData != null) {
            n = this.startData.length;
        }
        return n;
    }

    public int getSeriesIndex(Comparable comparable) {
        int n = -1;
        for (int i = 0; i < this.seriesKeys.length; ++i) {
            if (!comparable.equals(this.seriesKeys[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public Comparable getSeriesKey(int n) {
        if (n >= this.getSeriesCount() || n < 0) {
            throw new IllegalArgumentException("No such series : " + n);
        }
        return this.seriesKeys[n];
    }

    public void setSeriesKeys(Comparable[] comparableArray) {
        if (comparableArray == null) {
            throw new IllegalArgumentException("Null 'seriesKeys' argument.");
        }
        if (comparableArray.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("The number of series keys does not match the data.");
        }
        this.seriesKeys = comparableArray;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int n = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            n = this.startData[0].length;
        }
        return n;
    }

    public List getColumnKeys() {
        if (this.categoryKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categoryKeys));
    }

    public void setCategoryKeys(Comparable[] comparableArray) {
        if (comparableArray == null) {
            throw new IllegalArgumentException("Null 'categoryKeys' argument.");
        }
        if (comparableArray.length != this.getCategoryCount()) {
            throw new IllegalArgumentException("The number of categories does not match the data.");
        }
        for (int i = 0; i < comparableArray.length; ++i) {
            if (comparableArray[i] != null) continue;
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategoryKeys(): null category not permitted.");
        }
        this.categoryKeys = comparableArray;
        this.fireDatasetChanged();
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        int n = this.getSeriesIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n2 = this.getColumnIndex(comparable2);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getValue(n, n2);
    }

    public Number getValue(int n, int n2) {
        return this.getEndValue(n, n2);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        int n = this.getSeriesIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n2 = this.getColumnIndex(comparable2);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getStartValue(n, n2);
    }

    public Number getStartValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): series index out of range.");
        }
        if (n2 < 0 || n2 >= this.getCategoryCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): category index out of range.");
        }
        return this.startData[n][n2];
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        int n = this.getSeriesIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n2 = this.getColumnIndex(comparable2);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getEndValue(n, n2);
    }

    public Number getEndValue(int n, int n2) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): series index out of range.");
        }
        if (n2 < 0 || n2 >= this.getCategoryCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): category index out of range.");
        }
        return this.endData[n][n2];
    }

    public void setStartValue(int n, Comparable comparable, Number number) {
        if (n < 0 || n > this.getSeriesCount() - 1) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n2 = this.getCategoryIndex(comparable);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.startData[n][n2] = number;
        this.fireDatasetChanged();
    }

    public void setEndValue(int n, Comparable comparable, Number number) {
        if (n < 0 || n > this.getSeriesCount() - 1) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n2 = this.getCategoryIndex(comparable);
        if (n2 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.endData[n][n2] = number;
        this.fireDatasetChanged();
    }

    public int getCategoryIndex(Comparable comparable) {
        int n = -1;
        for (int i = 0; i < this.categoryKeys.length; ++i) {
            if (!comparable.equals(this.categoryKeys[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    private Comparable[] generateKeys(int n, String string) {
        Comparable[] comparableArray = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            String string2 = string + (i + 1);
            comparableArray[i] = string2;
        }
        return comparableArray;
    }

    public Comparable getColumnKey(int n) {
        return this.categoryKeys[n];
    }

    public int getColumnIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        return this.getCategoryIndex(comparable);
    }

    public int getRowIndex(Comparable comparable) {
        return this.getSeriesIndex(comparable);
    }

    public List getRowKeys() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    public Comparable getRowKey(int n) {
        if (n >= this.getRowCount() || n < 0) {
            throw new IllegalArgumentException("The 'row' argument is out of bounds.");
        }
        return this.seriesKeys[n];
    }

    public int getColumnCount() {
        return this.categoryKeys.length;
    }

    public int getRowCount() {
        return this.seriesKeys.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultIntervalCategoryDataset)) {
            return false;
        }
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = (DefaultIntervalCategoryDataset)object;
        if (!Arrays.equals(this.seriesKeys, defaultIntervalCategoryDataset.seriesKeys)) {
            return false;
        }
        if (!Arrays.equals(this.categoryKeys, defaultIntervalCategoryDataset.categoryKeys)) {
            return false;
        }
        if (!DefaultIntervalCategoryDataset.equal(this.startData, defaultIntervalCategoryDataset.startData)) {
            return false;
        }
        return DefaultIntervalCategoryDataset.equal(this.endData, defaultIntervalCategoryDataset.endData);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = (DefaultIntervalCategoryDataset)super.clone();
        defaultIntervalCategoryDataset.categoryKeys = (Comparable[])this.categoryKeys.clone();
        defaultIntervalCategoryDataset.seriesKeys = (Comparable[])this.seriesKeys.clone();
        defaultIntervalCategoryDataset.startData = DefaultIntervalCategoryDataset.clone(this.startData);
        defaultIntervalCategoryDataset.endData = DefaultIntervalCategoryDataset.clone(this.endData);
        return defaultIntervalCategoryDataset;
    }

    private static boolean equal(Number[][] numberArray, Number[][] numberArray2) {
        if (numberArray == null) {
            return numberArray2 == null;
        }
        if (numberArray2 == null) {
            return false;
        }
        if (numberArray.length != numberArray2.length) {
            return false;
        }
        for (int i = 0; i < numberArray.length; ++i) {
            if (Arrays.equals(numberArray[i], numberArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static Number[][] clone(Number[][] numberArray) {
        if (numberArray == null) {
            throw new IllegalArgumentException("Null 'array' argument.");
        }
        Number[][] numberArray2 = new Number[numberArray.length][];
        for (int i = 0; i < numberArray.length; ++i) {
            Number[] numberArray3 = numberArray[i];
            Number[] numberArray4 = new Number[numberArray3.length];
            System.arraycopy(numberArray3, 0, numberArray4, 0, numberArray3.length);
            numberArray2[i] = numberArray4;
        }
        return numberArray2;
    }

    public List getSeries() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    public List getCategories() {
        return this.getColumnKeys();
    }

    public int getItemCount() {
        return this.categoryKeys.length;
    }
}

