/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data.category;

import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.AbstractDataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.util.TableOrder;
import java.util.Collections;
import java.util.List;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset,
DatasetChangeListener {
    static final long serialVersionUID = 5516396319762189617L;
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset categoryDataset, TableOrder tableOrder, int n) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = categoryDataset;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.extract = tableOrder;
        this.index = n;
    }

    public CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public TableOrder getExtractType() {
        return this.extract;
    }

    public int getExtractIndex() {
        return this.index;
    }

    public int getItemCount() {
        int n = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n = this.source.getRowCount();
            }
        }
        return n;
    }

    public Number getValue(int n) {
        Number number = null;
        if (n < 0 || n >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("The 'item' index is out of bounds.");
        }
        if (this.extract == TableOrder.BY_ROW) {
            number = this.source.getValue(this.index, n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            number = this.source.getValue(n, this.index);
        }
        return number;
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        if (n < 0 || n >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("Invalid 'index': " + n);
        }
        if (this.extract == TableOrder.BY_ROW) {
            comparable = this.source.getColumnKey(n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            comparable = this.source.getRowKey(n);
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n = this.source.getColumnIndex(comparable);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n = this.source.getRowIndex(comparable);
            }
        }
        return n;
    }

    public List getKeys() {
        List list = Collections.EMPTY_LIST;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                list = this.source.getColumnKeys();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                list = this.source.getRowKeys();
            }
        }
        return list;
    }

    public Number getValue(Comparable comparable) {
        Number number = null;
        int n = this.getIndex(comparable);
        if (n != -1) {
            if (this.extract == TableOrder.BY_ROW) {
                number = this.source.getValue(this.index, n);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                number = this.source.getValue(n, this.index);
            }
        }
        return number;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n = this.getItemCount();
        if (pieDataset.getItemCount() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i);
            if (!comparable2.equals(comparable = pieDataset.getKey(i))) {
                return false;
            }
            Number number = this.getValue(i);
            Number number2 = pieDataset.getValue(i);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }
}

