/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.data.KeyedObjects;
import ai.org.jfree.data.UnknownKeyException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyedObjects2D
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1015873563138522374L;
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Object getObject(int n, int n2) {
        int n3;
        Comparable comparable;
        Object object = null;
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n);
        if (keyedObjects != null && (comparable = (Comparable)this.columnKeys.get(n2)) != null && (n3 = keyedObjects.getIndex(comparable)) >= 0) {
            object = keyedObjects.getObject(comparable);
        }
        return object;
    }

    public Comparable getRowKey(int n) {
        return (Comparable)this.rowKeys.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.rowKeys.indexOf(comparable);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.columnKeys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return this.columnKeys.indexOf(comparable);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Object getObject(Comparable comparable, Comparable comparable2) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (comparable2 == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        int n = this.rowKeys.indexOf(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            throw new UnknownKeyException("Column key (" + comparable2 + ") not recognised.");
        }
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n);
        int n3 = keyedObjects.getIndex(comparable2);
        if (n3 >= 0) {
            return keyedObjects.getObject(n3);
        }
        return null;
    }

    public void addObject(Object object, Comparable comparable, Comparable comparable2) {
        this.setObject(object, comparable, comparable2);
    }

    public void setObject(Object object, Comparable comparable, Comparable comparable2) {
        KeyedObjects keyedObjects;
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (comparable2 == null) {
            throw new IllegalArgumentException("Null 'columnKey' argument.");
        }
        int n = this.rowKeys.indexOf(comparable);
        if (n >= 0) {
            keyedObjects = (KeyedObjects)this.rows.get(n);
        } else {
            this.rowKeys.add(comparable);
            keyedObjects = new KeyedObjects();
            this.rows.add(keyedObjects);
        }
        keyedObjects.setObject(comparable2, object);
        int n2 = this.columnKeys.indexOf(comparable2);
        if (n2 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeObject(Comparable comparable, Comparable comparable2) {
        int n;
        int n2;
        int n3 = this.getRowIndex(comparable);
        if (n3 < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        int n4 = this.getColumnIndex(comparable2);
        if (n4 < 0) {
            throw new UnknownKeyException("Column key (" + comparable2 + ") not recognised.");
        }
        this.setObject(null, comparable, comparable2);
        boolean bl = true;
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n3);
        int n5 = keyedObjects.getItemCount();
        for (n2 = 0; n2 < n5; ++n2) {
            if (keyedObjects.getObject(n2) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.rowKeys.remove(n3);
            this.rows.remove(n3);
        }
        bl = true;
        n5 = this.rows.size();
        for (n2 = 0; n2 < n5; ++n2) {
            keyedObjects = (KeyedObjects)this.rows.get(n2);
            n = keyedObjects.getIndex(comparable2);
            if (n < 0 || keyedObjects.getObject(n) == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n5 = this.rows.size();
            for (n2 = 0; n2 < n5; ++n2) {
                keyedObjects = (KeyedObjects)this.rows.get(n2);
                n = keyedObjects.getIndex(comparable2);
                if (n < 0) continue;
                keyedObjects.removeValue(n);
            }
            this.columnKeys.remove(comparable2);
        }
    }

    public void removeRow(int n) {
        this.rowKeys.remove(n);
        this.rows.remove(n);
    }

    public void removeRow(Comparable comparable) {
        int n = this.getRowIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        this.removeRow(n);
    }

    public void removeColumn(int n) {
        Comparable comparable = this.getColumnKey(n);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        int n = this.getColumnIndex(comparable);
        if (n < 0) {
            throw new UnknownKeyException("Column key (" + comparable + ") not recognised.");
        }
        for (KeyedObjects keyedObjects : this.rows) {
            int n2 = keyedObjects.getIndex(comparable);
            if (n2 < 0) continue;
            keyedObjects.removeValue(n2);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects2D)) {
            return false;
        }
        KeyedObjects2D keyedObjects2D = (KeyedObjects2D)object;
        if (!this.getRowKeys().equals(keyedObjects2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedObjects2D.getColumnKeys())) {
            return false;
        }
        int n = this.getRowCount();
        if (n != keyedObjects2D.getRowCount()) {
            return false;
        }
        int n2 = this.getColumnCount();
        if (n2 != keyedObjects2D.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object2 = this.getObject(i, j);
                Object object3 = keyedObjects2D.getObject(i, j);
                if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.rowKeys.hashCode();
        n = 29 * n + this.columnKeys.hashCode();
        n = 29 * n + this.rows.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects2D keyedObjects2D = (KeyedObjects2D)super.clone();
        keyedObjects2D.columnKeys = new ArrayList(this.columnKeys);
        keyedObjects2D.rowKeys = new ArrayList(this.rowKeys);
        keyedObjects2D.rows = new ArrayList(this.rows.size());
        for (KeyedObjects keyedObjects : this.rows) {
            keyedObjects2D.rows.add(keyedObjects.clone());
        }
        return keyedObjects2D;
    }
}

