/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KeyToGroupMap
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2228169345475318082L;
    private Comparable defaultGroup;
    private List groups;
    private Map keyToGroupMap;

    public KeyToGroupMap() {
        this((Comparable)((Object)"Default Group"));
    }

    public KeyToGroupMap(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'defaultGroup' argument.");
        }
        this.defaultGroup = comparable;
        this.groups = new ArrayList();
        this.keyToGroupMap = new HashMap();
    }

    public int getGroupCount() {
        return this.groups.size() + 1;
    }

    public List getGroups() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        arrayList.add(this.defaultGroup);
        for (Comparable comparable : this.groups) {
            if (arrayList.contains(comparable)) continue;
            arrayList.add(comparable);
        }
        return arrayList;
    }

    public int getGroupIndex(Comparable comparable) {
        int n = this.groups.indexOf(comparable);
        if (n < 0) {
            if (this.defaultGroup.equals(comparable)) {
                n = 0;
            }
        } else {
            ++n;
        }
        return n;
    }

    public Comparable getGroup(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Comparable comparable2 = this.defaultGroup;
        Comparable comparable3 = (Comparable)this.keyToGroupMap.get(comparable);
        if (comparable3 != null) {
            comparable2 = comparable3;
        }
        return comparable2;
    }

    public void mapKeyToGroup(Comparable comparable, Comparable comparable2) {
        int n;
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Comparable comparable3 = this.getGroup(comparable);
        if (!comparable3.equals(this.defaultGroup) && !comparable3.equals(comparable2) && (n = this.getKeyCount(comparable3)) == 1) {
            this.groups.remove(comparable3);
        }
        if (comparable2 == null) {
            this.keyToGroupMap.remove(comparable);
        } else {
            if (!this.groups.contains(comparable2) && !this.defaultGroup.equals(comparable2)) {
                this.groups.add(comparable2);
            }
            this.keyToGroupMap.put(comparable, comparable2);
        }
    }

    public int getKeyCount(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        int n = 0;
        for (Comparable comparable2 : this.keyToGroupMap.values()) {
            if (!comparable.equals(comparable2)) continue;
            ++n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyToGroupMap)) {
            return false;
        }
        KeyToGroupMap keyToGroupMap = (KeyToGroupMap)object;
        if (!ObjectUtilities.equal(this.defaultGroup, keyToGroupMap.defaultGroup)) {
            return false;
        }
        return this.keyToGroupMap.equals(keyToGroupMap.keyToGroupMap);
    }

    public Object clone() throws CloneNotSupportedException {
        KeyToGroupMap keyToGroupMap = (KeyToGroupMap)super.clone();
        keyToGroupMap.defaultGroup = (Comparable)KeyToGroupMap.clone(this.defaultGroup);
        keyToGroupMap.groups = (List)KeyToGroupMap.clone(this.groups);
        keyToGroupMap.keyToGroupMap = (Map)KeyToGroupMap.clone(this.keyToGroupMap);
        return keyToGroupMap;
    }

    private static Object clone(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Object object2 = null;
        try {
            Method method = clazz.getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                try {
                    object2 = method.invoke(object, (Object[])null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object2 = object;
        }
        return object2;
    }

    private static Collection clone(Collection collection) throws CloneNotSupportedException {
        List list = null;
        if (collection != null) {
            try {
                List list2 = (List)collection.getClass().newInstance();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    list2.add(KeyToGroupMap.clone(iterator.next()));
                }
                list = list2;
            }
            catch (Exception exception) {
                throw new CloneNotSupportedException("Exception.");
            }
        }
        return list;
    }
}

