/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.data;

import ai.org.jfree.data.DefaultKeyedValues;
import ai.org.jfree.data.KeyedValues;
import ai.org.jfree.data.Values2D;
import java.util.Arrays;

public abstract class DataUtilities {
    public static boolean equal(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Arrays.equals(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static double[][] clone(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == null) continue;
            double[] dArray2 = new double[dArray[i].length];
            System.arraycopy(dArray[i], 0, dArray2, 0, dArray[i].length);
            dArrayArray[i] = dArray2;
        }
        return dArrayArray;
    }

    public static double calculateColumnTotal(Values2D values2D, int n) {
        if (values2D == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double d = 0.0;
        int n2 = values2D.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Number number = values2D.getValue(i, n);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static double calculateColumnTotal(Values2D values2D, int n, int[] nArray) {
        if (values2D == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double d = 0.0;
        int n2 = values2D.getRowCount();
        for (int i = 0; i < nArray.length; ++i) {
            Number number;
            int n3 = nArray[i];
            if (n3 >= n2 || (number = values2D.getValue(n3, n)) == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static double calculateRowTotal(Values2D values2D, int n) {
        if (values2D == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double d = 0.0;
        int n2 = values2D.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Number number = values2D.getValue(n, i);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static double calculateRowTotal(Values2D values2D, int n, int[] nArray) {
        if (values2D == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        double d = 0.0;
        int n2 = values2D.getColumnCount();
        for (int i = 0; i < nArray.length; ++i) {
            Number number;
            int n3 = nArray[i];
            if (n3 >= n2 || (number = values2D.getValue(n, n3)) == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static Number[] createNumberArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] numberArray = new Number[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int n = dArray.length;
        Number[][] numberArray = new Number[n][];
        for (int i = 0; i < n; ++i) {
            numberArray[i] = DataUtilities.createNumberArray(dArray[i]);
        }
        return numberArray;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        double d = 0.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            Number number = keyedValues.getValue(i);
            if (number == null) continue;
            d += number.doubleValue();
        }
        double d2 = 0.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            Number number = keyedValues.getValue(i);
            if (number != null) {
                d2 += number.doubleValue();
            }
            defaultKeyedValues.addValue(keyedValues.getKey(i), new Double(d2 / d));
        }
        return defaultKeyedValues;
    }
}

