/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class LogFormat
extends NumberFormat {
    private double base;
    private double baseLog;
    private String baseLabel;
    private String powerLabel;
    private boolean showBase;
    private NumberFormat formatter = new DecimalFormat("0.0#");

    public LogFormat() {
        this(10.0, "10", true);
    }

    public LogFormat(double d, String string, boolean bl) {
        this(d, string, "^", bl);
    }

    public LogFormat(double d, String string, String string2, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'baseLabel' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'powerLabel' argument.");
        }
        this.base = d;
        this.baseLog = Math.log(this.base);
        this.baseLabel = string;
        this.showBase = bl;
        this.powerLabel = string2;
    }

    public NumberFormat getExponentFormat() {
        return (NumberFormat)this.formatter.clone();
    }

    public void setExponentFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatter = numberFormat;
    }

    private double calculateLog(double d) {
        return Math.log(d) / this.baseLog;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.showBase) {
            stringBuffer2.append(this.baseLabel);
            stringBuffer2.append(this.powerLabel);
        }
        stringBuffer2.append(this.formatter.format(this.calculateLog(d)));
        return stringBuffer2;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.showBase) {
            stringBuffer2.append(this.baseLabel);
            stringBuffer2.append(this.powerLabel);
        }
        stringBuffer2.append(this.formatter.format(this.calculateLog(l)));
        return stringBuffer2;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogFormat)) {
            return false;
        }
        LogFormat logFormat = (LogFormat)object;
        if (this.base != logFormat.base) {
            return false;
        }
        if (!this.baseLabel.equals(logFormat.baseLabel)) {
            return false;
        }
        if (this.baseLog != logFormat.baseLog) {
            return false;
        }
        if (this.showBase != logFormat.showBase) {
            return false;
        }
        if (!this.formatter.equals(logFormat.formatter)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() {
        LogFormat logFormat = (LogFormat)super.clone();
        logFormat.formatter = (NumberFormat)this.formatter.clone();
        return logFormat;
    }
}

