/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.util;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.util.ShadowGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Serializable;

public class DefaultShadowGenerator
implements ShadowGenerator,
Serializable {
    private static final long serialVersionUID = 2732993885591386064L;
    private int shadowSize;
    private Color shadowColor;
    private float shadowOpacity;
    private double angle;
    private int distance;

    public DefaultShadowGenerator() {
        this(5, Color.black, 0.5f, 5, -0.7853981633974483);
    }

    public DefaultShadowGenerator(int n, Color color, float f, int n2, double d) {
        if (color == null) {
            throw new IllegalArgumentException("Null 'color' argument.");
        }
        this.shadowSize = n;
        this.shadowColor = color;
        this.shadowOpacity = f;
        this.distance = n2;
        this.angle = d;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    public int calculateOffsetX() {
        return (int)(Math.cos(this.angle) * (double)this.distance) - this.shadowSize;
    }

    public int calculateOffsetY() {
        return -((int)(Math.sin(this.angle) * (double)this.distance)) - this.shadowSize;
    }

    public BufferedImage createDropShadow(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.shadowSize * 2, bufferedImage.getHeight() + this.shadowSize * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.shadowSize, this.shadowSize);
        graphics2D.dispose();
        this.applyShadow(bufferedImage2);
        return bufferedImage2;
    }

    protected void applyShadow(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = this.shadowSize - 1 >> 1;
        int n7 = this.shadowSize - n6;
        int n8 = n6;
        int n9 = n4 - n7;
        int n10 = n6;
        int n11 = n5 - n7;
        int n12 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[this.shadowSize];
        int n13 = 0;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n14 = n7 * n4;
        float f = this.shadowOpacity / (float)this.shadowSize;
        int n15 = 0;
        int n16 = 0;
        while (n15 < n5) {
            n3 = 0;
            n13 = 0;
            n2 = 0;
            while (n2 < this.shadowSize) {
                nArray[n2] = n = nArray2[n16] >>> 24;
                n3 += n;
                ++n2;
                ++n16;
            }
            n16 -= n7;
            n2 = n8;
            while (n2 < n9) {
                n = (int)((float)n3 * f);
                nArray2[n16] = n << 24 | n12;
                n3 -= nArray[n13];
                nArray[n13] = n = nArray2[n16 + n7] >>> 24;
                n3 += n;
                if (++n13 >= this.shadowSize) {
                    n13 -= this.shadowSize;
                }
                ++n2;
                ++n16;
            }
            n16 = ++n15 * n4;
        }
        n15 = 0;
        n16 = 0;
        while (n15 < n4) {
            n3 = 0;
            n13 = 0;
            n2 = 0;
            while (n2 < this.shadowSize) {
                nArray[n2] = n = nArray2[n16] >>> 24;
                n3 += n;
                ++n2;
                n16 += n4;
            }
            n16 -= n14;
            n2 = n10;
            while (n2 < n11) {
                n = (int)((float)n3 * f);
                nArray2[n16] = n << 24 | n12;
                n3 -= nArray[n13];
                nArray[n13] = n = nArray2[n16 + n14] >>> 24;
                n3 += n;
                if (++n13 >= this.shadowSize) {
                    n13 -= this.shadowSize;
                }
                ++n2;
                n16 += n4;
            }
            n16 = ++n15;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultShadowGenerator)) {
            return false;
        }
        DefaultShadowGenerator defaultShadowGenerator = (DefaultShadowGenerator)object;
        if (this.shadowSize != defaultShadowGenerator.shadowSize) {
            return false;
        }
        if (!this.shadowColor.equals(defaultShadowGenerator.shadowColor)) {
            return false;
        }
        if (this.shadowOpacity != defaultShadowGenerator.shadowOpacity) {
            return false;
        }
        if (this.distance != defaultShadowGenerator.distance) {
            return false;
        }
        return this.angle == defaultShadowGenerator.angle;
    }

    public int hashCode() {
        int n = HashUtilities.hashCode(17, this.shadowSize);
        n = HashUtilities.hashCode(n, this.shadowColor);
        n = HashUtilities.hashCode(n, this.shadowOpacity);
        n = HashUtilities.hashCode(n, this.distance);
        n = HashUtilities.hashCode(n, this.angle);
        return n;
    }
}

